/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.disparity.sgm;

import boofcv.alg.feature.disparity.sgm.SgmHelper;
import boofcv.alg.misc.GImageMiscOps;
import boofcv.concurrency.BoofConcurrency;
import boofcv.concurrency.IntRangeObjectConsumer;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.Planar;
import org.ddogleg.struct.FastQueue;

public class SgmCostAggregation {
    protected SgmHelper helper = new SgmHelper();
    Planar<GrayU16> aggregated = new Planar<GrayU16>(GrayU16.class, 1, 1, 2);
    Planar<GrayU16> costYXD;
    int lengthX;
    int lengthY;
    int lengthD;
    int effectiveLengthX;
    int disparityMin;
    int pathsConsidered = 8;
    int penalty1 = 200;
    int penalty2 = 2000;
    FastQueue<Trajectory> trajectories = new FastQueue<Trajectory>(Trajectory.class, () -> new Trajectory());
    FastQueue<WorkSpace> workspace = new FastQueue<WorkSpace>(WorkSpace.class, () -> new WorkSpace());
    ComputeBlock computeBlock = new ComputeBlock();

    public void configure(int disparityMin) {
        this.disparityMin = disparityMin;
    }

    public void process(Planar<GrayU16> costYXD) {
        this.init(costYXD);
        if (this.pathsConsidered >= 1) {
            this.scoreDirection(1, 0);
        }
        if (this.pathsConsidered >= 2) {
            this.scoreDirection(-1, 0);
        }
        if (this.pathsConsidered >= 4) {
            this.scoreDirection(0, 1);
            this.scoreDirection(0, -1);
        }
        if (this.pathsConsidered >= 8) {
            this.scoreDirection(1, 1);
            this.scoreDirection(-1, -1);
            this.scoreDirection(-1, 1);
            this.scoreDirection(1, -1);
        }
        if (this.pathsConsidered >= 16) {
            this.scoreDirection(1, 2);
            this.scoreDirection(2, 1);
            this.scoreDirection(2, -1);
            this.scoreDirection(1, -2);
            this.scoreDirection(-1, -2);
            this.scoreDirection(-2, -1);
            this.scoreDirection(-2, 1);
            this.scoreDirection(-1, 2);
        }
    }

    void init(Planar<GrayU16> costYXD) {
        if (this.pathsConsidered < 1 || this.pathsConsidered > 16) {
            throw new IllegalArgumentException("Number of paths must be 1 to 16, inclusive. Not " + this.pathsConsidered);
        }
        this.costYXD = costYXD;
        this.aggregated.reshape(costYXD);
        GImageMiscOps.fill(this.aggregated, 0.0);
        this.lengthX = costYXD.getHeight();
        this.lengthD = costYXD.getWidth();
        this.lengthY = costYXD.getNumBands();
        this.effectiveLengthX = this.lengthX - this.disparityMin;
        this.helper.configure(this.lengthX, this.disparityMin, this.lengthD);
        this.workspace.resize(1);
    }

    void scoreDirection(int dx, int dy) {
        int x;
        int x1;
        int x0;
        int y;
        this.trajectories.reset();
        if (dx > 0) {
            for (y = 0; y < this.lengthY; ++y) {
                this.trajectories.grow().set(0, y, dx, dy);
            }
        } else if (dx < 0) {
            for (y = 0; y < this.lengthY; ++y) {
                this.trajectories.grow().set(this.effectiveLengthX - 1, y, dx, dy);
            }
        }
        if (dy > 0) {
            x0 = 0;
            x1 = this.effectiveLengthX;
            if (dx > 0) {
                ++x0;
            }
            if (dx < 0) {
                --x1;
            }
            for (x = x0; x < x1; ++x) {
                this.trajectories.grow().set(x, 0, dx, dy);
            }
        } else if (dy < 0) {
            x0 = 0;
            x1 = this.effectiveLengthX;
            if (dx > 0) {
                ++x0;
            }
            if (dx < 0) {
                --x1;
            }
            for (x = x0; x < x1; ++x) {
                this.trajectories.grow().set(x, this.lengthY - 1, dx, dy);
            }
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            BoofConcurrency.loopBlocks(0, this.trajectories.size, 1, this.workspace, this.computeBlock);
        } else {
            WorkSpace w = (WorkSpace)this.workspace.get(0);
            w.checkSize();
            for (int i = 0; i < this.trajectories.size; ++i) {
                Trajectory t = (Trajectory)this.trajectories.get(i);
                this.scorePath(t.x0, t.y0, t.dx, t.dy, w.workCostLr);
            }
        }
    }

    void scorePath(int x0, int y0, int dx, int dy, short[] workCostLr) {
        int d;
        int minCost = Integer.MAX_VALUE;
        GrayU16 costXD = this.costYXD.getBand(y0);
        int idxCost = costXD.getIndex(0, x0);
        int localRangeD = this.helper.localDisparityRangeLeft(x0 + this.disparityMin);
        for (d = 0; d < localRangeD; ++d) {
            int v = costXD.data[idxCost + d] & 0xFFFF;
            workCostLr[d] = (short)v;
            minCost = Math.min(minCost, v);
        }
        for (d = 0; d < localRangeD; ++d) {
            workCostLr[d] = (short)((workCostLr[d] & 0xFFFF) - minCost);
        }
        if (localRangeD != this.helper.disparityRange) {
            workCostLr[localRangeD] = workCostLr[localRangeD - 1];
        }
        int lengthPath = this.computePathLength(x0, y0, dx, dy);
        int i = 1;
        int x = x0 + dx;
        int y = y0 + dy;
        while (i < lengthPath) {
            int d2;
            GrayU16 costXD2 = this.costYXD.getBand(y);
            int idxCost2 = costXD2.getIndex(0, x);
            int localRangeD2 = this.helper.localDisparityRangeLeft(x + this.disparityMin);
            int idxLrPrev = (i - 1) * this.lengthD;
            this.computeCostInnerD(costXD2.data, idxCost2, idxLrPrev, localRangeD2, workCostLr);
            this.computeCostBorderD(idxCost2, idxLrPrev, 0, costXD2, localRangeD2, workCostLr);
            this.computeCostBorderD(idxCost2, idxLrPrev, localRangeD2 - 1, costXD2, localRangeD2, workCostLr);
            if (localRangeD2 != this.helper.disparityRange) {
                workCostLr[idxLrPrev + this.lengthD + localRangeD2] = workCostLr[idxLrPrev + this.lengthD + localRangeD2 - 1];
            }
            int minCost2 = Integer.MAX_VALUE;
            int idxLr = i * this.lengthD;
            for (d2 = 0; d2 < localRangeD2; ++d2) {
                minCost2 = Math.min(minCost2, workCostLr[idxLr + d2] & 0xFFFF);
            }
            for (d2 = 0; d2 < localRangeD2; ++d2) {
                workCostLr[idxLr + d2] = (short)((workCostLr[idxLr + d2] & 0xFFFF) - minCost2);
            }
            ++i;
            x += dx;
            y += dy;
        }
        this.saveWorkToAggregated(x0, y0, dx, dy, lengthPath, workCostLr);
    }

    void saveWorkToAggregated(int x0, int y0, int dx, int dy, int length, short[] workCostLr) {
        int i = 0;
        int x = x0;
        int y = y0;
        while (i < length) {
            int localLengthD = this.helper.localDisparityRangeLeft(x + this.disparityMin);
            GrayU16 aggrXD = this.aggregated.getBand(y);
            int idxWork = i * this.lengthD;
            int idxAggr = aggrXD.getIndex(0, x);
            int d = 0;
            while (d < localLengthD) {
                aggrXD.data[idxAggr] = (short)((aggrXD.data[idxAggr] & 0xFFFF) + (workCostLr[idxWork] & 0xFFFF));
                ++d;
                ++idxAggr;
                ++idxWork;
            }
            ++i;
            x += dx;
            y += dy;
        }
    }

    void computeCostInnerD(short[] costXD, int idxCost, int idxLrPrev, int lengthLocalD, short[] workCostLr) {
        int nextRow = this.lengthD - 1;
        int penalty1 = this.penalty1;
        int penalty2 = this.penalty2;
        int c1 = workCostLr[++idxLrPrev - 1] & 0xFFFF;
        int c2 = workCostLr[idxLrPrev] & 0xFFFF;
        ++idxLrPrev;
        int d = 1;
        while (d < lengthLocalD - 1) {
            int cost = costXD[idxCost + d] & 0xFFFF;
            int c0 = c1;
            c1 = c2;
            c2 = workCostLr[idxLrPrev] & 0xFFFF;
            int a = c1;
            int b = c0 + penalty1;
            int c = c2 + penalty1;
            if (b < a) {
                a = b;
            }
            if (c < a) {
                a = c;
            }
            if (penalty2 < a) {
                a = penalty2;
            }
            workCostLr[idxLrPrev + nextRow] = (short)(cost + a);
            ++d;
            ++idxLrPrev;
        }
    }

    void computeCostBorderD(int idxCost, int idxLrPrev, int d, GrayU16 costXD, int localRangeD, short[] workCostLr) {
        int cost = costXD.data[idxCost + d] & 0xFFFF;
        int a = workCostLr[idxLrPrev + d] & 0xFFFF;
        int b = d > 0 ? workCostLr[idxLrPrev + d - 1] & 0xFFFF : 2047;
        int c = d < localRangeD - 1 ? workCostLr[idxLrPrev + d + 1] & 0xFFFF : 2047;
        c += this.penalty1;
        if ((b += this.penalty1) < a) {
            a = b;
        }
        if (c < a) {
            a = c;
        }
        if (this.penalty2 < a) {
            a = this.penalty2;
        }
        workCostLr[idxLrPrev + this.lengthD + d] = (short)(cost + a);
    }

    int computePathLength(int x0, int y0, int dx, int dy) {
        int pathX = this.pathLength(x0, dx, this.effectiveLengthX);
        int pathY = this.pathLength(y0, dy, this.lengthY);
        return Math.min(pathX, pathY);
    }

    private int pathLength(int t0, int step, int length) {
        if (step > 0) {
            return (length - t0 + step / 2) / step;
        }
        if (step < 0) {
            return (t0 + 1 - step / 2) / -step;
        }
        return Integer.MAX_VALUE;
    }

    public Planar<GrayU16> getAggregated() {
        return this.aggregated;
    }

    public int getPenalty1() {
        return this.penalty1;
    }

    public void setPenalty1(int penalty1) {
        this.penalty1 = penalty1;
    }

    public int getPenalty2() {
        return this.penalty2;
    }

    public void setPenalty2(int penalty2) {
        this.penalty2 = penalty2;
    }

    public int getPathsConsidered() {
        return this.pathsConsidered;
    }

    public void setPathsConsidered(int pathsConsidered) {
        this.pathsConsidered = pathsConsidered;
    }

    private static class Trajectory {
        public int x0;
        public int y0;
        public int dx;
        public int dy;

        private Trajectory() {
        }

        public void set(int x0, int y0, int dx, int dy) {
            this.x0 = x0;
            this.y0 = y0;
            this.dx = dx;
            this.dy = dy;
        }
    }

    class WorkSpace {
        short[] workCostLr = new short[0];

        WorkSpace() {
        }

        public void checkSize() {
            int N = Math.max(SgmCostAggregation.this.lengthX, SgmCostAggregation.this.lengthY) * SgmCostAggregation.this.lengthD;
            if (this.workCostLr.length != N) {
                this.workCostLr = new short[N];
            }
        }
    }

    private class ComputeBlock
    implements IntRangeObjectConsumer<WorkSpace> {
        private ComputeBlock() {
        }

        @Override
        public void accept(WorkSpace workspace, int minInclusive, int maxExclusive) {
            workspace.checkSize();
            for (int i = minInclusive; i < maxExclusive; ++i) {
                Trajectory t = (Trajectory)SgmCostAggregation.this.trajectories.get(i);
                SgmCostAggregation.this.scorePath(t.x0, t.y0, t.dx, t.dy, workspace.workCostLr);
            }
        }
    }
}

