/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.disparity.block.select;

import boofcv.alg.feature.disparity.block.SelectSparseStandardWta;
import boofcv.alg.feature.disparity.block.score.DisparitySparseRectifiedScoreBM;

public class SelectSparseErrorWithChecksWta_F32
extends SelectSparseStandardWta<float[]> {
    protected float textureThreshold;

    public SelectSparseErrorWithChecksWta_F32(int maxError, double texture, int tolRightToLeft) {
        super(maxError, texture, tolRightToLeft);
    }

    @Override
    protected void setTexture(double texture) {
        this.textureThreshold = (float)texture;
    }

    @Override
    public boolean select(DisparitySparseRectifiedScoreBM<float[], ?> scorer, int x, int y) {
        if (!scorer.processLeftToRight(x, y)) {
            return false;
        }
        float[] scores = scorer.getScoreLtoR();
        int disparityRange = scorer.getLocalRangeLtoR();
        int bestDisparity = 0;
        float scoreBest = scores[0];
        for (int i = 1; i < disparityRange; ++i) {
            if (!(scores[i] < scoreBest)) continue;
            scoreBest = scores[i];
            bestDisparity = i;
        }
        if (scoreBest > (float)this.maxError) {
            return false;
        }
        if (this.textureThreshold > 0.0f && disparityRange >= 3) {
            int i;
            float secondBest = Float.MAX_VALUE;
            for (i = 0; i < bestDisparity - 1; ++i) {
                if (!(scores[i] < secondBest)) continue;
                secondBest = scores[i];
            }
            for (i = bestDisparity + 2; i < disparityRange; ++i) {
                if (!(scores[i] < secondBest)) continue;
                secondBest = scores[i];
            }
            if (secondBest - scoreBest <= this.textureThreshold * scoreBest) {
                return false;
            }
        }
        if (this.tolRightToLeft >= 0) {
            if (!scorer.processRightToLeft(x - bestDisparity - scorer.getDisparityMin(), y)) {
                return false;
            }
            float[] scoresRtoL = scorer.getScoreRtoL();
            int localRangeRtoL = scorer.getLocalRangeRtoL();
            int bestDisparityRtoL = 0;
            float scoreBestRtoL = scoresRtoL[0];
            for (int i = 1; i < localRangeRtoL; ++i) {
                if (!(scoresRtoL[i] < scoreBestRtoL)) continue;
                scoreBestRtoL = scoresRtoL[i];
                bestDisparityRtoL = i;
            }
            if (Math.abs(bestDisparityRtoL - bestDisparity) > this.tolRightToLeft) {
                return false;
            }
        }
        this.disparity = bestDisparity;
        return true;
    }
}

