/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.disparity.block;

import boofcv.abst.transform.census.FilterCensusTransform;
import boofcv.alg.descriptor.DescriptorDistance;
import boofcv.alg.feature.disparity.block.score.DisparitySparseRectifiedScoreBM_S32;
import boofcv.struct.image.GrayI;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS64;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;

public interface SparseScoreRectifiedCensus {

    public static class S64<T extends GrayI<T>>
    extends Census<T, GrayS64> {
        public S64(int radiusX, int radiusY, FilterCensusTransform<T, GrayS64> censusTran, Class<T> imageType) {
            super(radiusX, radiusY, censusTran, imageType);
        }

        @Override
        protected void scoreCensus(int disparityRange, boolean leftToRight) {
            int[] scores = leftToRight ? this.scoreLtoR : this.scoreRtoL;
            long[] dataLeft = ((GrayS64)this.censusLeft).data;
            long[] dataRight = ((GrayS64)this.censusRight).data;
            for (int d = 0; d < disparityRange; ++d) {
                int total = 0;
                for (int y = 0; y < this.blockHeight; ++y) {
                    int idxLeft = (y + this.sampleRadiusY) * ((GrayS64)this.censusLeft).stride + this.sampleRadiusX;
                    int idxRight = (y + this.sampleRadiusY) * ((GrayS64)this.censusRight).stride + this.sampleRadiusX + d;
                    for (int x = 0; x < this.blockWidth; ++x) {
                        long a = dataLeft[idxLeft++];
                        long b = dataRight[idxRight++];
                        total += DescriptorDistance.hamming(a ^ b);
                    }
                }
                int index = leftToRight ? disparityRange - d - 1 : d;
                scores[index] = total;
            }
        }
    }

    public static class S32<T extends GrayI<T>>
    extends Census<T, GrayS32> {
        public S32(int radiusX, int radiusY, FilterCensusTransform<T, GrayS32> censusTran, Class<T> imageType) {
            super(radiusX, radiusY, censusTran, imageType);
        }

        @Override
        protected void scoreCensus(int disparityRange, boolean leftToRight) {
            int[] scores = leftToRight ? this.scoreLtoR : this.scoreRtoL;
            int[] dataLeft = ((GrayS32)this.censusLeft).data;
            int[] dataRight = ((GrayS32)this.censusRight).data;
            for (int d = 0; d < disparityRange; ++d) {
                int total = 0;
                for (int y = 0; y < this.blockHeight; ++y) {
                    int idxLeft = (y + this.sampleRadiusY) * ((GrayS32)this.censusLeft).stride + this.sampleRadiusX;
                    int idxRight = (y + this.sampleRadiusY) * ((GrayS32)this.censusRight).stride + this.sampleRadiusX + d;
                    for (int x = 0; x < this.blockWidth; ++x) {
                        int a = dataLeft[idxLeft++];
                        int b = dataRight[idxRight++];
                        total += DescriptorDistance.hamming(a ^ b);
                    }
                }
                int index = leftToRight ? disparityRange - d - 1 : d;
                scores[index] = total;
            }
        }
    }

    public static class U8<T extends GrayI<T>>
    extends Census<T, GrayU8> {
        public U8(int radiusX, int radiusY, FilterCensusTransform<T, GrayU8> censusTran, Class<T> imageType) {
            super(radiusX, radiusY, censusTran, imageType);
        }

        @Override
        protected void scoreCensus(int disparityRange, boolean leftToRight) {
            int[] scores = leftToRight ? this.scoreLtoR : this.scoreRtoL;
            byte[] dataLeft = ((GrayU8)this.censusLeft).data;
            byte[] dataRight = ((GrayU8)this.censusRight).data;
            for (int d = 0; d < disparityRange; ++d) {
                int total = 0;
                for (int y = 0; y < this.blockHeight; ++y) {
                    int idxLeft = (y + this.sampleRadiusY) * ((GrayU8)this.censusLeft).stride + this.sampleRadiusX;
                    int idxRight = (y + this.sampleRadiusY) * ((GrayU8)this.censusRight).stride + this.sampleRadiusX + d;
                    for (int x = 0; x < this.blockWidth; ++x) {
                        int a = dataLeft[idxLeft++] & 0xFF;
                        int b = dataRight[idxRight++] & 0xFF;
                        total += DescriptorDistance.hamming(a ^ b);
                    }
                }
                int index = leftToRight ? disparityRange - d - 1 : d;
                scores[index] = total;
            }
        }
    }

    public static abstract class Census<In extends ImageGray<In>, Out extends ImageGray<Out>>
    extends DisparitySparseRectifiedScoreBM_S32<In> {
        FilterCensusTransform<In, Out> censusTran;
        Out censusLeft;
        Out censusRight;

        public Census(int radiusX, int radiusY, FilterCensusTransform<In, Out> censusTran, Class<In> imageType) {
            super(radiusX, radiusY, imageType);
            this.censusTran = censusTran;
            this.setSampleRegion(censusTran.getRadiusX(), censusTran.getRadiusY());
            this.censusLeft = (ImageGray)censusTran.getOutputType().createImage(1, 1);
            this.censusRight = (ImageGray)censusTran.getOutputType().createImage(1, 1);
        }

        @Override
        public void configure(int disparityMin, int disparityRange) {
            super.configure(disparityMin, disparityRange);
            ((ImageGray)this.censusLeft).reshape(this.patchTemplate);
        }

        @Override
        protected void scoreDisparity(int disparityRange, boolean leftToRight) {
            ((ImageGray)this.censusRight).reshape(this.patchCompare);
            this.censusTran.process(this.patchTemplate, this.censusLeft);
            this.censusTran.process(this.patchCompare, this.censusRight);
            this.scoreCensus(disparityRange, leftToRight);
        }

        protected abstract void scoreCensus(int var1, boolean var2);
    }
}

