/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.selector;

import boofcv.alg.feature.detect.selector.FeatureSelectLimit;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.ConfigGridUniform;
import boofcv.struct.ImageGrid;
import boofcv.struct.image.GrayF32;
import georegression.struct.point.Point2D_I16;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.ddogleg.sorting.QuickSort_F32;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_F32;
import org.ddogleg.struct.GrowQueue_I32;

public class FeatureSelectUniformBest
implements FeatureSelectLimit {
    public ConfigGridUniform configUniform = new ConfigGridUniform();
    ImageGrid<Info> grid = new ImageGrid<Info>(Info::new, Info::reset);
    GrowQueue_F32 pointIntensity = new GrowQueue_F32();
    QuickSort_F32 sorter = new QuickSort_F32();
    GrowQueue_I32 indexes = new GrowQueue_I32();
    List<Point2D_I16> workList = new ArrayList<Point2D_I16>();

    @Override
    public void select(GrayF32 intensity, boolean positive, @Nullable FastAccess<Point2D_I16> prior, FastAccess<Point2D_I16> detected, int limit, FastQueue<Point2D_I16> selected) {
        Point2D_I16 p;
        int i;
        selected.reset();
        if ((prior == null || prior.size == 0) && detected.size <= limit) {
            BoofMiscOps.copyAll_2D_I16(detected, selected);
            return;
        }
        int targetCellSize = this.configUniform.selectTargetCellSize(limit, intensity.width, intensity.height);
        this.grid.initialize(targetCellSize, intensity.width, intensity.height);
        if (prior != null) {
            for (i = 0; i < prior.size; ++i) {
                p = ((Point2D_I16[])prior.data)[i];
                ++this.grid.getCellAtPixel((int)p.x, (int)p.y).priorCount;
            }
        }
        for (i = 0; i < detected.size; ++i) {
            p = ((Point2D_I16[])detected.data)[i];
            this.grid.getCellAtPixel((int)p.x, (int)p.y).detected.add(p);
        }
        this.sortCellLists(intensity, positive);
        FastQueue cells = this.grid.cells;
        while (selected.size < limit) {
            boolean change = false;
            for (int cellidx = 0; cellidx < cells.size && selected.size < limit; ++cellidx) {
                Info info = (Info)cells.get(cellidx);
                if (info.priorCount > 0) {
                    --info.priorCount;
                    change = true;
                    continue;
                }
                if (info.detected.isEmpty()) continue;
                selected.grow().set(info.detected.remove(info.detected.size() - 1));
                change = true;
            }
            if (change) continue;
            break;
        }
    }

    private void sortCellLists(GrayF32 intensity, boolean positive) {
        FastQueue cells = this.grid.cells;
        for (int cellidx = 0; cellidx < cells.size; ++cellidx) {
            Point2D_I16 p;
            int pointIdx;
            List<Point2D_I16> cellPoints = ((Info)cells.get((int)cellidx)).detected;
            if (cellPoints.isEmpty()) continue;
            int N = cellPoints.size();
            this.pointIntensity.resize(N);
            this.indexes.resize(N);
            if (positive) {
                for (pointIdx = 0; pointIdx < N; ++pointIdx) {
                    p = cellPoints.get(pointIdx);
                    this.pointIntensity.data[pointIdx] = intensity.unsafe_get(p.x, p.y);
                }
            } else {
                for (pointIdx = 0; pointIdx < N; ++pointIdx) {
                    p = cellPoints.get(pointIdx);
                    this.pointIntensity.data[pointIdx] = -intensity.unsafe_get(p.x, p.y);
                }
            }
            this.sorter.sort(this.pointIntensity.data, 0, N, this.indexes.data);
            this.workList.clear();
            for (int i = 0; i < N; ++i) {
                this.workList.add(cellPoints.get(this.indexes.data[i]));
            }
            List<Point2D_I16> tmp = ((Info[])cells.data)[cellidx].detected;
            ((Info[])cells.data)[cellidx].detected = this.workList;
            this.workList = tmp;
        }
    }

    public static class Info {
        int priorCount = 0;
        List<Point2D_I16> detected = new ArrayList<Point2D_I16>();

        public void reset() {
            this.priorCount = 0;
            this.detected.clear();
        }
    }
}

