/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.selector;

import boofcv.alg.feature.detect.selector.FeatureSelectLimit;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.image.GrayF32;
import georegression.struct.point.Point2D_I16;
import org.ddogleg.sorting.QuickSelect;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.FastQueue;

public class FeatureSelectNBest
implements FeatureSelectLimit {
    int[] indexes = new int[1];
    float[] indexIntensity = new float[1];

    @Override
    public void select(GrayF32 intensity, boolean positive, FastAccess<Point2D_I16> prior, FastAccess<Point2D_I16> detected, int limit, FastQueue<Point2D_I16> selected) {
        Point2D_I16 pt;
        int i;
        selected.reset();
        if (detected.size <= limit) {
            BoofMiscOps.copyAll_2D_I16(detected, selected);
            return;
        }
        if (detected.size > this.indexes.length) {
            this.indexes = new int[detected.size];
            this.indexIntensity = new float[detected.size];
        }
        Point2D_I16[] points = (Point2D_I16[])detected.data;
        if (positive) {
            for (i = 0; i < detected.size; ++i) {
                pt = points[i];
                this.indexIntensity[i] = -intensity.get(pt.x, pt.y);
            }
        } else {
            for (i = 0; i < detected.size; ++i) {
                pt = points[i];
                this.indexIntensity[i] = intensity.get(pt.x, pt.y);
            }
        }
        QuickSelect.selectIndex(this.indexIntensity, limit, detected.size, this.indexes);
        for (i = 0; i < limit; ++i) {
            selected.grow().set(((Point2D_I16[])detected.data)[this.indexes[i]]);
        }
    }
}

