/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.intensity.impl;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.feature.detect.intensity.impl.ImplSsdCornerBase;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;

public abstract class ImplSsdCornerBox<D extends ImageGray<D>, D2 extends ImageGray<D2>>
extends ImplSsdCornerBase<D, D2> {
    protected ImplSsdCornerBox(int windowRadius, Class<D> derivType, Class<D2> secondDerivType) {
        super(windowRadius, derivType, secondDerivType);
    }

    @Override
    public void process(D derivX, D derivY, GrayF32 intensity) {
        InputSanityCheck.checkSameShape(derivX, derivY);
        intensity.reshape(((ImageGray)derivX).width, ((ImageGray)derivY).height);
        this.setImageShape(((ImageBase)derivX).getWidth(), ((ImageBase)derivX).getHeight());
        this.derivX = derivX;
        this.derivY = derivY;
        ImageMiscOps.fillBorder(intensity, 0.0f, this.radius);
        this.horizontal();
        this.vertical(intensity);
    }

    protected abstract void horizontal();

    protected abstract void vertical(GrayF32 var1);
}

