/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.intensity.impl;

import boofcv.alg.feature.detect.intensity.impl.FastCornerInterface;
import boofcv.struct.image.GrayU8;

public abstract class ImplFastHelper_U8
implements FastCornerInterface<GrayU8> {
    protected int tol;
    protected int[] offsets;
    protected byte[] data;
    int centerValue;
    int lower;
    int upper;

    public ImplFastHelper_U8(int pixelTol) {
        this.tol = pixelTol;
    }

    @Override
    public void setImage(GrayU8 image, int[] offsets) {
        this.data = image.data;
        this.offsets = offsets;
    }

    @Override
    public float scoreLower(int index) {
        int total = 0;
        int count = 0;
        for (int i = 0; i < this.offsets.length; ++i) {
            int v = this.data[index + this.offsets[i]] & 0xFF;
            if (v >= this.lower) continue;
            total += v;
            ++count;
        }
        if (count == 0) {
            return 0.0f;
        }
        return total - this.centerValue * count;
    }

    @Override
    public float scoreUpper(int index) {
        int total = 0;
        int count = 0;
        for (int i = 0; i < this.offsets.length; ++i) {
            int v = this.data[index + this.offsets[i]] & 0xFF;
            if (v <= this.upper) continue;
            total += v;
            ++count;
        }
        if (count == 0) {
            return 0.0f;
        }
        return total - this.centerValue * count;
    }

    @Override
    public void setThreshold(int index) {
        this.centerValue = this.data[index] & 0xFF;
        this.lower = this.centerValue - this.tol;
        this.upper = this.centerValue + this.tol;
    }

    @Override
    public Class<GrayU8> getImageType() {
        return GrayU8.class;
    }
}

