/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.extract;

import boofcv.alg.feature.detect.extract.NonMaxBlock;
import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.QueueCorner;
import boofcv.struct.image.GrayF32;
import javax.annotation.Nullable;
import org.ddogleg.struct.FastQueue;

public class NonMaxBlock_MT
extends NonMaxBlock {
    final FastQueue<SearchData> searches = new FastQueue<SearchData>(this::createSearchData);

    public NonMaxBlock_MT(NonMaxBlock.Search search) {
        super(search);
    }

    @Override
    public void process(GrayF32 intensityImage, @Nullable QueueCorner localMin, @Nullable QueueCorner localMax) {
        if (localMin != null) {
            localMin.reset();
        }
        if (localMax != null) {
            localMax.reset();
        }
        int endX = intensityImage.width - this.border;
        int endY = intensityImage.height - this.border;
        int step = this.configuration.radius + 1;
        this.search.initialize(this.configuration, intensityImage, localMin, localMax);
        int range = endY - this.border;
        int N = range / step;
        if (range > N * step) {
            ++N;
        }
        BoofConcurrency.loopBlocks(0, N, this.searches, (blockInfo, iter0, iter1) -> {
            NonMaxBlock.Search search = blockInfo.search;
            blockInfo.cornersMin.reset();
            blockInfo.cornersMax.reset();
            QueueCorner threadMin = localMin != null ? blockInfo.cornersMin : null;
            QueueCorner threadMax = localMax != null ? blockInfo.cornersMax : null;
            search.initialize(this.configuration, intensityImage, threadMin, threadMax);
            for (int iterY = iter0; iterY < iter1; ++iterY) {
                int y = this.border + iterY * step;
                int y1 = y + step;
                if (y1 > endY) {
                    y1 = endY;
                }
                for (int x = this.border; x < endX; x += step) {
                    int x1 = x + step;
                    if (x1 > endX) {
                        x1 = endX;
                    }
                    search.searchBlock(x, y, x1, y1);
                }
            }
        });
        for (int i = 0; i < this.searches.size; ++i) {
            SearchData data = (SearchData)this.searches.get(i);
            if (localMin != null) {
                localMin.appendAll(data.cornersMin);
            }
            if (localMax == null) continue;
            localMax.appendAll(data.cornersMax);
        }
    }

    public SearchData createSearchData() {
        return new SearchData(this.search.newInstance());
    }

    protected static class SearchData {
        public final NonMaxBlock.Search search;
        public final QueueCorner cornersMin = new QueueCorner();
        public final QueueCorner cornersMax = new QueueCorner();

        public SearchData(NonMaxBlock.Search search) {
            this.search = search;
        }
    }
}

