/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.edge.impl;

import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;

public class ImplGradientToEdgeFeatures_MT {
    public static void intensityE(GrayF32 derivX, GrayF32 derivY, GrayF32 intensity) {
        int w = derivX.width;
        int h = derivY.height;
        BoofConcurrency.loopFor(0, h, y -> {
            int indexX = derivX.startIndex + y * derivX.stride;
            int indexY = derivY.startIndex + y * derivY.stride;
            int indexI = intensity.startIndex + y * intensity.stride;
            int end = indexX + w;
            while (indexX < end) {
                float dx = derivX.data[indexX];
                float dy = derivY.data[indexY];
                intensity.data[indexI] = (float)Math.sqrt(dx * dx + dy * dy);
                ++indexX;
                ++indexY;
                ++indexI;
            }
        });
    }

    public static void intensityAbs(GrayF32 derivX, GrayF32 derivY, GrayF32 intensity) {
        int w = derivX.width;
        int h = derivY.height;
        BoofConcurrency.loopFor(0, h, y -> {
            int indexX = derivX.startIndex + y * derivX.stride;
            int indexY = derivY.startIndex + y * derivY.stride;
            int indexI = intensity.startIndex + y * intensity.stride;
            int end = indexX + w;
            while (indexX < end) {
                intensity.data[indexI] = Math.abs(derivX.data[indexX]) + Math.abs(derivY.data[indexY]);
                ++indexX;
                ++indexY;
                ++indexI;
            }
        });
    }

    public static void direction(GrayF32 derivX, GrayF32 derivY, GrayF32 angle) {
        int w = derivX.width;
        int h = derivY.height;
        BoofConcurrency.loopFor(0, h, y -> {
            int indexX = derivX.startIndex + y * derivX.stride;
            int indexY = derivY.startIndex + y * derivY.stride;
            int indexA = angle.startIndex + y * angle.stride;
            int end = indexX + w;
            while (indexX < end) {
                float dx = derivX.data[indexX];
                float dy = derivY.data[indexY];
                angle.data[indexA] = Math.abs(dx) < 1.0E-10f ? 1.5707964f : (float)Math.atan(dy / dx);
                ++indexX;
                ++indexY;
                ++indexA;
            }
        });
    }

    public static void direction2(GrayF32 derivX, GrayF32 derivY, GrayF32 angle) {
        int w = derivX.width;
        int h = derivY.height;
        BoofConcurrency.loopFor(0, h, y -> {
            int indexX = derivX.startIndex + y * derivX.stride;
            int indexY = derivY.startIndex + y * derivY.stride;
            int indexA = angle.startIndex + y * angle.stride;
            int end = indexX + w;
            while (indexX < end) {
                float dx = derivX.data[indexX];
                float dy = derivY.data[indexY];
                angle.data[indexA] = (float)Math.atan2(dy, dx);
                ++indexX;
                ++indexY;
                ++indexA;
            }
        });
    }

    public static void intensityE(GrayS16 derivX, GrayS16 derivY, GrayF32 intensity) {
        int w = derivX.width;
        int h = derivY.height;
        BoofConcurrency.loopFor(0, h, y -> {
            int indexX = derivX.startIndex + y * derivX.stride;
            int indexY = derivY.startIndex + y * derivY.stride;
            int indexI = intensity.startIndex + y * intensity.stride;
            int end = indexX + w;
            while (indexX < end) {
                short dx = derivX.data[indexX];
                short dy = derivY.data[indexY];
                intensity.data[indexI] = (float)Math.sqrt(dx * dx + dy * dy);
                ++indexX;
                ++indexY;
                ++indexI;
            }
        });
    }

    public static void intensityAbs(GrayS16 derivX, GrayS16 derivY, GrayF32 intensity) {
        int w = derivX.width;
        int h = derivY.height;
        BoofConcurrency.loopFor(0, h, y -> {
            int indexX = derivX.startIndex + y * derivX.stride;
            int indexY = derivY.startIndex + y * derivY.stride;
            int indexI = intensity.startIndex + y * intensity.stride;
            int end = indexX + w;
            while (indexX < end) {
                intensity.data[indexI] = Math.abs(derivX.data[indexX]) + Math.abs(derivY.data[indexY]);
                ++indexX;
                ++indexY;
                ++indexI;
            }
        });
    }

    public static void direction(GrayS16 derivX, GrayS16 derivY, GrayF32 angle) {
        int w = derivX.width;
        int h = derivY.height;
        BoofConcurrency.loopFor(0, h, y -> {
            int indexX = derivX.startIndex + y * derivX.stride;
            int indexY = derivY.startIndex + y * derivY.stride;
            int indexA = angle.startIndex + y * angle.stride;
            int end = indexX + w;
            while (indexX < end) {
                short dx = derivX.data[indexX];
                short dy = derivY.data[indexY];
                angle.data[indexA] = dx == 0 ? 1.5707964f : (float)Math.atan((double)dy / (double)dx);
                ++indexX;
                ++indexY;
                ++indexA;
            }
        });
    }

    public static void direction2(GrayS16 derivX, GrayS16 derivY, GrayF32 angle) {
        int w = derivX.width;
        int h = derivY.height;
        BoofConcurrency.loopFor(0, h, y -> {
            int indexX = derivX.startIndex + y * derivX.stride;
            int indexY = derivY.startIndex + y * derivY.stride;
            int indexA = angle.startIndex + y * angle.stride;
            int end = indexX + w;
            while (indexX < end) {
                short dx = derivX.data[indexX];
                short dy = derivY.data[indexY];
                angle.data[indexA] = (float)Math.atan2(dy, dx);
                ++indexX;
                ++indexY;
                ++indexA;
            }
        });
    }

    public static void intensityE(GrayS32 derivX, GrayS32 derivY, GrayF32 intensity) {
        int w = derivX.width;
        int h = derivY.height;
        BoofConcurrency.loopFor(0, h, y -> {
            int indexX = derivX.startIndex + y * derivX.stride;
            int indexY = derivY.startIndex + y * derivY.stride;
            int indexI = intensity.startIndex + y * intensity.stride;
            int end = indexX + w;
            while (indexX < end) {
                int dx = derivX.data[indexX];
                int dy = derivY.data[indexY];
                intensity.data[indexI] = (float)Math.sqrt(dx * dx + dy * dy);
                ++indexX;
                ++indexY;
                ++indexI;
            }
        });
    }

    public static void intensityAbs(GrayS32 derivX, GrayS32 derivY, GrayF32 intensity) {
        int w = derivX.width;
        int h = derivY.height;
        BoofConcurrency.loopFor(0, h, y -> {
            int indexX = derivX.startIndex + y * derivX.stride;
            int indexY = derivY.startIndex + y * derivY.stride;
            int indexI = intensity.startIndex + y * intensity.stride;
            int end = indexX + w;
            while (indexX < end) {
                intensity.data[indexI] = Math.abs(derivX.data[indexX]) + Math.abs(derivY.data[indexY]);
                ++indexX;
                ++indexY;
                ++indexI;
            }
        });
    }

    public static void direction(GrayS32 derivX, GrayS32 derivY, GrayF32 angle) {
        int w = derivX.width;
        int h = derivY.height;
        BoofConcurrency.loopFor(0, h, y -> {
            int indexX = derivX.startIndex + y * derivX.stride;
            int indexY = derivY.startIndex + y * derivY.stride;
            int indexA = angle.startIndex + y * angle.stride;
            int end = indexX + w;
            while (indexX < end) {
                int dx = derivX.data[indexX];
                int dy = derivY.data[indexY];
                angle.data[indexA] = dx == 0 ? 1.5707964f : (float)Math.atan((double)dy / (double)dx);
                ++indexX;
                ++indexY;
                ++indexA;
            }
        });
    }

    public static void direction2(GrayS32 derivX, GrayS32 derivY, GrayF32 angle) {
        int w = derivX.width;
        int h = derivY.height;
        BoofConcurrency.loopFor(0, h, y -> {
            int indexX = derivX.startIndex + y * derivX.stride;
            int indexY = derivY.startIndex + y * derivY.stride;
            int indexA = angle.startIndex + y * angle.stride;
            int end = indexX + w;
            while (indexX < end) {
                int dx = derivX.data[indexX];
                int dy = derivY.data[indexY];
                angle.data[indexA] = (float)Math.atan2(dy, dx);
                ++indexX;
                ++indexY;
                ++indexA;
            }
        });
    }
}

