/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.edge.impl;

import boofcv.concurrency.BoofConcurrency;
import boofcv.core.image.border.FactoryImageBorderAlgs;
import boofcv.struct.border.ImageBorder_F32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS8;

public class ImplEdgeNonMaxSuppression_MT {
    public static void inner4(GrayF32 intensity, GrayS8 direction, GrayF32 output) {
        int w = intensity.width;
        int h = intensity.height - 1;
        BoofConcurrency.loopFor(1, h, y -> {
            int indexI = intensity.startIndex + y * intensity.stride + 1;
            int indexD = direction.startIndex + y * direction.stride + 1;
            int indexO = output.startIndex + y * output.stride + 1;
            int end = indexI + w - 2;
            while (indexI < end) {
                int dy;
                int dx;
                byte dir = direction.data[indexD];
                if (dir == 0) {
                    dx = 1;
                    dy = 0;
                } else if (dir == 1) {
                    dx = 1;
                    dy = 1;
                } else if (dir == 2) {
                    dx = 0;
                    dy = 1;
                } else {
                    dx = 1;
                    dy = -1;
                }
                float middle = intensity.data[indexI];
                output.data[indexO] = intensity.data[indexI - dx - dy * intensity.stride] > middle || intensity.data[indexI + dx + dy * intensity.stride] > middle ? 0.0f : middle;
                ++indexI;
                ++indexD;
                ++indexO;
            }
        });
    }

    public static void naive4(GrayF32 _intensity, GrayS8 direction, GrayF32 output) {
        int w = _intensity.width;
        int h = _intensity.height;
        ImageBorder_F32 intensity = FactoryImageBorderAlgs.value(_intensity, 0.0f);
        BoofConcurrency.loopFor(0, h, y -> {
            for (int x = 0; x < w; ++x) {
                int dy;
                int dx;
                int dir = direction.get(x, y);
                if (dir == 0) {
                    dx = 1;
                    dy = 0;
                } else if (dir == 1) {
                    dx = 1;
                    dy = 1;
                } else if (dir == 2) {
                    dx = 0;
                    dy = 1;
                } else {
                    dx = 1;
                    dy = -1;
                }
                float left = intensity.get(x - dx, y - dy);
                float middle = intensity.get(x, y);
                float right = intensity.get(x + dx, y + dy);
                if (left > middle || right > middle) {
                    output.set(x, y, 0.0f);
                    continue;
                }
                output.set(x, y, middle);
            }
        });
    }

    public static void border4(GrayF32 _intensity, GrayS8 direction, GrayF32 output) {
        int w = _intensity.width;
        int h = _intensity.height - 1;
        ImageBorder_F32 intensity = FactoryImageBorderAlgs.value(_intensity, 0.0f);
        BoofConcurrency.loopFor(0, w, x -> {
            int dy;
            int dx;
            int dir = direction.get(x, 0);
            if (dir == 0) {
                dx = 1;
                dy = 0;
            } else if (dir == 1) {
                dx = 1;
                dy = 1;
            } else if (dir == 2) {
                dx = 0;
                dy = 1;
            } else {
                dx = 1;
                dy = -1;
            }
            float left = intensity.get(x - dx, -dy);
            float middle = intensity.get(x, 0);
            float right = intensity.get(x + dx, dy);
            if (left > middle || right > middle) {
                output.set(x, 0, 0.0f);
            } else {
                output.set(x, 0, middle);
            }
        });
        BoofConcurrency.loopFor(0, w, x -> {
            int dy;
            int dx;
            int dir = direction.get(x, h);
            if (dir == 0) {
                dx = 1;
                dy = 0;
            } else if (dir == 1) {
                dx = 1;
                dy = 1;
            } else if (dir == 2) {
                dx = 0;
                dy = 1;
            } else {
                dx = 1;
                dy = -1;
            }
            float left = intensity.get(x - dx, h - dy);
            float middle = intensity.get(x, h);
            float right = intensity.get(x + dx, h + dy);
            if (left > middle || right > middle) {
                output.set(x, h, 0.0f);
            } else {
                output.set(x, h, middle);
            }
        });
        BoofConcurrency.loopFor(1, h, y -> {
            int dy;
            int dx;
            int dir = direction.get(0, y);
            if (dir == 0) {
                dx = 1;
                dy = 0;
            } else if (dir == 1) {
                dx = 1;
                dy = 1;
            } else if (dir == 2) {
                dx = 0;
                dy = 1;
            } else {
                dx = 1;
                dy = -1;
            }
            float left = intensity.get(-dx, y - dy);
            float middle = intensity.get(0, y);
            float right = intensity.get(dx, y + dy);
            if (left > middle || right > middle) {
                output.set(0, y, 0.0f);
            } else {
                output.set(0, y, middle);
            }
        });
        int _w = w - 1;
        BoofConcurrency.loopFor(1, h, y -> {
            int dy;
            int dx;
            int dir = direction.get(_w, y);
            if (dir == 0) {
                dx = 1;
                dy = 0;
            } else if (dir == 1) {
                dx = 1;
                dy = 1;
            } else if (dir == 2) {
                dx = 0;
                dy = 1;
            } else {
                dx = 1;
                dy = -1;
            }
            float left = intensity.get(_w - dx, y - dy);
            float middle = intensity.get(_w, y);
            float right = intensity.get(_w + dx, y + dy);
            if (left > middle || right > middle) {
                output.set(_w, y, 0.0f);
            } else {
                output.set(_w, y, middle);
            }
        });
    }

    public static void inner8(GrayF32 intensity, GrayS8 direction, GrayF32 output) {
        int w = intensity.width;
        int h = intensity.height - 1;
        BoofConcurrency.loopFor(1, h, y -> {
            int indexI = intensity.startIndex + y * intensity.stride + 1;
            int indexD = direction.startIndex + y * direction.stride + 1;
            int indexO = output.startIndex + y * output.stride + 1;
            int end = indexI + w - 2;
            while (indexI < end) {
                int dy;
                int dx;
                byte dir = direction.data[indexD];
                if (dir == 0 || dir == 4) {
                    dx = 1;
                    dy = 0;
                } else if (dir == 1 || dir == -3) {
                    dx = 1;
                    dy = 1;
                } else if (dir == 2 || dir == -2) {
                    dx = 0;
                    dy = 1;
                } else {
                    dx = 1;
                    dy = -1;
                }
                float middle = intensity.data[indexI];
                output.data[indexO] = intensity.data[indexI - dx - dy * intensity.stride] > middle || intensity.data[indexI + dx + dy * intensity.stride] > middle ? 0.0f : middle;
                ++indexI;
                ++indexD;
                ++indexO;
            }
        });
    }

    public static void naive8(GrayF32 _intensity, GrayS8 direction, GrayF32 output) {
        int w = _intensity.width;
        int h = _intensity.height;
        ImageBorder_F32 intensity = FactoryImageBorderAlgs.value(_intensity, 0.0f);
        BoofConcurrency.loopFor(0, h, y -> {
            for (int x = 0; x < w; ++x) {
                int dy;
                int dx;
                int dir = direction.get(x, y);
                if (dir == 0 || dir == 4) {
                    dx = 1;
                    dy = 0;
                } else if (dir == 1 || dir == -3) {
                    dx = 1;
                    dy = 1;
                } else if (dir == 2 || dir == -2) {
                    dx = 0;
                    dy = 1;
                } else {
                    dx = 1;
                    dy = -1;
                }
                float left = intensity.get(x - dx, y - dy);
                float middle = intensity.get(x, y);
                float right = intensity.get(x + dx, y + dy);
                if (left > middle || right > middle) {
                    output.set(x, y, 0.0f);
                    continue;
                }
                output.set(x, y, middle);
            }
        });
    }

    public static void border8(GrayF32 _intensity, GrayS8 direction, GrayF32 output) {
        int w = _intensity.width;
        int h = _intensity.height - 1;
        ImageBorder_F32 intensity = FactoryImageBorderAlgs.value(_intensity, 0.0f);
        BoofConcurrency.loopFor(0, w, x -> {
            int dy;
            int dx;
            int dir = direction.get(x, 0);
            if (dir == 0 || dir == 4) {
                dx = 1;
                dy = 0;
            } else if (dir == 1 || dir == -3) {
                dx = 1;
                dy = 1;
            } else if (dir == 2 || dir == -2) {
                dx = 0;
                dy = 1;
            } else {
                dx = 1;
                dy = -1;
            }
            float left = intensity.get(x - dx, -dy);
            float middle = intensity.get(x, 0);
            float right = intensity.get(x + dx, dy);
            if (left > middle || right > middle) {
                output.set(x, 0, 0.0f);
            } else {
                output.set(x, 0, middle);
            }
        });
        BoofConcurrency.loopFor(0, w, x -> {
            int dy;
            int dx;
            int dir = direction.get(x, h);
            if (dir == 0 || dir == 4) {
                dx = 1;
                dy = 0;
            } else if (dir == 1 || dir == -3) {
                dx = 1;
                dy = 1;
            } else if (dir == 2 || dir == -2) {
                dx = 0;
                dy = 1;
            } else {
                dx = 1;
                dy = -1;
            }
            float left = intensity.get(x - dx, h - dy);
            float middle = intensity.get(x, h);
            float right = intensity.get(x + dx, h + dy);
            if (left > middle || right > middle) {
                output.set(x, h, 0.0f);
            } else {
                output.set(x, h, middle);
            }
        });
        BoofConcurrency.loopFor(1, h, y -> {
            int dy;
            int dx;
            int dir = direction.get(0, y);
            if (dir == 0 || dir == 4) {
                dx = 1;
                dy = 0;
            } else if (dir == 1 || dir == -3) {
                dx = 1;
                dy = 1;
            } else if (dir == 2 || dir == -2) {
                dx = 0;
                dy = 1;
            } else {
                dx = 1;
                dy = -1;
            }
            float left = intensity.get(-dx, y - dy);
            float middle = intensity.get(0, y);
            float right = intensity.get(dx, y + dy);
            if (left > middle || right > middle) {
                output.set(0, y, 0.0f);
            } else {
                output.set(0, y, middle);
            }
        });
        int _w = w - 1;
        BoofConcurrency.loopFor(1, h, y -> {
            int dy;
            int dx;
            int dir = direction.get(_w, y);
            if (dir == 0 || dir == 4) {
                dx = 1;
                dy = 0;
            } else if (dir == 1 || dir == -3) {
                dx = 1;
                dy = 1;
            } else if (dir == 2 || dir == -2) {
                dx = 0;
                dy = 1;
            } else {
                dx = 1;
                dy = -1;
            }
            float left = intensity.get(_w - dx, y - dy);
            float middle = intensity.get(_w, y);
            float right = intensity.get(_w + dx, y + dy);
            if (left > middle || right > middle) {
                output.set(_w, y, 0.0f);
            } else {
                output.set(_w, y, middle);
            }
        });
    }
}

