/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.edge.impl;

import boofcv.concurrency.BoofConcurrency;
import boofcv.core.image.border.FactoryImageBorderAlgs;
import boofcv.struct.border.ImageBorder_F32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayI;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;

public class ImplEdgeNonMaxSuppressionCrude_MT {
    public static void inner4(GrayF32 intensity, GrayF32 derivX, GrayF32 derivY, GrayF32 output) {
        int w = intensity.width;
        int h = intensity.height - 1;
        BoofConcurrency.loopFor(1, h, y -> {
            int indexI = intensity.startIndex + y * intensity.stride + 1;
            int indexX = derivX.startIndex + y * derivX.stride + 1;
            int indexY = derivY.startIndex + y * derivY.stride + 1;
            int indexO = output.startIndex + y * output.stride + 1;
            int end = indexI + w - 2;
            while (indexI < end) {
                int dx = derivX.data[indexX] > 0.0f ? 1 : -1;
                int dy = derivY.data[indexY] > 0.0f ? 1 : -1;
                float middle = intensity.data[indexI];
                output.data[indexO] = intensity.data[indexI - dx - dy * intensity.stride] > middle || intensity.data[indexI + dx + dy * intensity.stride] > middle ? 0.0f : middle;
                ++indexI;
                ++indexX;
                ++indexY;
                ++indexO;
            }
        });
    }

    public static void inner4(GrayF32 intensity, GrayS16 derivX, GrayS16 derivY, GrayF32 output) {
        int w = intensity.width;
        int h = intensity.height - 1;
        BoofConcurrency.loopFor(1, h, y -> {
            int indexI = intensity.startIndex + y * intensity.stride + 1;
            int indexX = derivX.startIndex + y * derivX.stride + 1;
            int indexY = derivY.startIndex + y * derivY.stride + 1;
            int indexO = output.startIndex + y * output.stride + 1;
            int end = indexI + w - 2;
            while (indexI < end) {
                int dx = derivX.data[indexX] > 0 ? 1 : -1;
                int dy = derivY.data[indexY] > 0 ? 1 : -1;
                float middle = intensity.data[indexI];
                output.data[indexO] = intensity.data[indexI - dx - dy * intensity.stride] > middle || intensity.data[indexI + dx + dy * intensity.stride] > middle ? 0.0f : middle;
                ++indexI;
                ++indexX;
                ++indexY;
                ++indexO;
            }
        });
    }

    public static void inner4(GrayF32 intensity, GrayS32 derivX, GrayS32 derivY, GrayF32 output) {
        int w = intensity.width;
        int h = intensity.height - 1;
        BoofConcurrency.loopFor(1, h, y -> {
            int indexI = intensity.startIndex + y * intensity.stride + 1;
            int indexX = derivX.startIndex + y * derivX.stride + 1;
            int indexY = derivY.startIndex + y * derivY.stride + 1;
            int indexO = output.startIndex + y * output.stride + 1;
            int end = indexI + w - 2;
            while (indexI < end) {
                int dx = derivX.data[indexX] > 0 ? 1 : -1;
                int dy = derivY.data[indexY] > 0 ? 1 : -1;
                float middle = intensity.data[indexI];
                output.data[indexO] = intensity.data[indexI - dx - dy * intensity.stride] > middle || intensity.data[indexI + dx + dy * intensity.stride] > middle ? 0.0f : middle;
                ++indexI;
                ++indexX;
                ++indexY;
                ++indexO;
            }
        });
    }

    public static void border4(GrayF32 _intensity, GrayF32 derivX, GrayF32 derivY, GrayF32 output) {
        int w = _intensity.width;
        int h = _intensity.height - 1;
        ImageBorder_F32 intensity = FactoryImageBorderAlgs.value(_intensity, 0.0f);
        BoofConcurrency.loopFor(0, w, x -> {
            int dx = derivX.get(x, 0) > 0.0f ? 1 : -1;
            int dy = derivY.get(x, 0) > 0.0f ? 1 : -1;
            float left = intensity.get(x - dx, -dy);
            float middle = intensity.get(x, 0);
            float right = intensity.get(x + dx, dy);
            if (left > middle || right > middle) {
                output.set(x, 0, 0.0f);
            } else {
                output.set(x, 0, middle);
            }
        });
        BoofConcurrency.loopFor(0, w, x -> {
            int dx = derivX.get(x, h) > 0.0f ? 1 : -1;
            int dy = derivY.get(x, h) > 0.0f ? 1 : -1;
            float left = intensity.get(x - dx, h - dy);
            float middle = intensity.get(x, h);
            float right = intensity.get(x + dx, h + dy);
            if (left > middle || right > middle) {
                output.set(x, h, 0.0f);
            } else {
                output.set(x, h, middle);
            }
        });
        BoofConcurrency.loopFor(1, h, y -> {
            int dx = derivX.get(0, y) > 0.0f ? 1 : -1;
            int dy = derivY.get(0, y) > 0.0f ? 1 : -1;
            float left = intensity.get(-dx, y - dy);
            float middle = intensity.get(0, y);
            float right = intensity.get(dx, y + dy);
            if (left > middle || right > middle) {
                output.set(0, y, 0.0f);
            } else {
                output.set(0, y, middle);
            }
        });
        int ww = w - 1;
        BoofConcurrency.loopFor(1, h, y -> {
            int dx = derivX.get(ww, y) > 0.0f ? 1 : -1;
            int dy = derivY.get(ww, y) > 0.0f ? 1 : -1;
            float left = intensity.get(ww - dx, y - dy);
            float middle = intensity.get(ww, y);
            float right = intensity.get(ww + dx, y + dy);
            if (left > middle || right > middle) {
                output.set(ww, y, 0.0f);
            } else {
                output.set(ww, y, middle);
            }
        });
    }

    public static void border4(GrayF32 _intensity, GrayI derivX, GrayI derivY, GrayF32 output) {
        int w = _intensity.width;
        int h = _intensity.height - 1;
        ImageBorder_F32 intensity = FactoryImageBorderAlgs.value(_intensity, 0.0f);
        BoofConcurrency.loopFor(0, w, x -> {
            int dx = derivX.get(x, 0) > 0 ? 1 : -1;
            int dy = derivY.get(x, 0) > 0 ? 1 : -1;
            float left = intensity.get(x - dx, -dy);
            float middle = intensity.get(x, 0);
            float right = intensity.get(x + dx, dy);
            if (left > middle || right > middle) {
                output.set(x, 0, 0.0f);
            } else {
                output.set(x, 0, middle);
            }
        });
        BoofConcurrency.loopFor(0, w, x -> {
            int dx = derivX.get(x, h) > 0 ? 1 : -1;
            int dy = derivY.get(x, h) > 0 ? 1 : -1;
            float left = intensity.get(x - dx, h - dy);
            float middle = intensity.get(x, h);
            float right = intensity.get(x + dx, h + dy);
            if (left > middle || right > middle) {
                output.set(x, h, 0.0f);
            } else {
                output.set(x, h, middle);
            }
        });
        BoofConcurrency.loopFor(1, h, y -> {
            int dx = derivX.get(0, y) > 0 ? 1 : -1;
            int dy = derivY.get(0, y) > 0 ? 1 : -1;
            float left = intensity.get(-dx, y - dy);
            float middle = intensity.get(0, y);
            float right = intensity.get(dx, y + dy);
            if (left > middle || right > middle) {
                output.set(0, y, 0.0f);
            } else {
                output.set(0, y, middle);
            }
        });
        int ww = w - 1;
        BoofConcurrency.loopFor(1, h, y -> {
            int dx = derivX.get(ww, y) > 0 ? 1 : -1;
            int dy = derivY.get(ww, y) > 0 ? 1 : -1;
            float left = intensity.get(ww - dx, y - dy);
            float middle = intensity.get(ww, y);
            float right = intensity.get(ww + dx, y + dy);
            if (left > middle || right > middle) {
                output.set(ww, y, 0.0f);
            } else {
                output.set(ww, y, middle);
            }
        });
    }
}

