/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.describe.impl;

import boofcv.alg.feature.describe.DescribePointPixelRegion;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.feature.TupleDesc_F32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageBase;
import java.util.Arrays;

public class ImplDescribePointPixelRegion_F32
extends DescribePointPixelRegion<GrayF32, TupleDesc_F32> {
    public ImplDescribePointPixelRegion_F32(int regionWidth, int regionHeight) {
        super(regionWidth, regionHeight);
    }

    @Override
    public void process(int c_x, int c_y, TupleDesc_F32 desc) {
        if (BoofMiscOps.isInside((ImageBase)this.image, c_x, c_y, this.radiusWidth, this.radiusHeight)) {
            int centerIndex = ((GrayF32)this.image).startIndex + c_y * ((GrayF32)this.image).stride + c_x;
            for (int i = 0; i < this.offset.length; ++i) {
                desc.value[i] = ((GrayF32)this.image).data[centerIndex + this.offset[i]];
            }
        } else {
            Arrays.fill(desc.value, 0.0f);
            int x0 = c_x - this.radiusWidth;
            int x1 = c_x + this.radiusWidth;
            int y0 = c_y - this.radiusHeight;
            int y1 = c_y + this.radiusHeight;
            if (x0 < 0) {
                x0 = 0;
            }
            if (y0 < 0) {
                y0 = 0;
            }
            if (x1 >= ((GrayF32)this.image).width) {
                x1 = ((GrayF32)this.image).width - 1;
            }
            if (y1 >= ((GrayF32)this.image).height) {
                y1 = ((GrayF32)this.image).height - 1;
            }
            for (int y = y0; y <= y1; ++y) {
                int indexImage = ((GrayF32)this.image).startIndex + y * ((GrayF32)this.image).stride + x0;
                int indexDesc = (y - (c_y - this.radiusHeight)) * this.regionWidth + (x0 - (c_x - this.radiusWidth));
                for (int x = x0; x <= x1; ++x) {
                    desc.value[indexDesc++] = ((GrayF32)this.image).data[indexImage++];
                }
            }
        }
    }

    @Override
    public Class<TupleDesc_F32> getDescriptorType() {
        return TupleDesc_F32.class;
    }
}

