/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.dense;

import boofcv.alg.feature.dense.BaseDenseHog;
import boofcv.alg.feature.describe.DescribeSiftCommon;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import georegression.metric.UtilAngle;
import georegression.misc.GrlConstants;
import georegression.struct.point.Point2D_I32;
import java.util.Arrays;
import java.util.List;

public class DescribeDenseHogFastAlg<Input extends ImageBase<Input>>
extends BaseDenseHog<Input> {
    Cell[] cells = new Cell[0];
    int cellRows;
    int cellCols;

    public DescribeDenseHogFastAlg(int orientationBins, int pixelsPerCell, int cellsPerBlockX, int cellsPerBlockY, int stepBlock, ImageType<Input> imageType) {
        super(orientationBins, pixelsPerCell, cellsPerBlockX, cellsPerBlockY, stepBlock, imageType);
    }

    @Override
    public void process() {
        this.locations.reset();
        this.descriptions.reset();
        this.growCellArray(this.derivX.width, this.derivX.height);
        this.computeCellHistograms();
        int cellRowMax = this.cellRows - (this.cellsPerBlockY - 1);
        int cellColMax = this.cellCols - (this.cellsPerBlockX - 1);
        for (int i = 0; i < cellRowMax; i += this.stepBlock) {
            for (int j = 0; j < cellColMax; j += this.stepBlock) {
                this.computeDescriptor(i, j);
            }
        }
    }

    void growCellArray(int imageWidth, int imageHeight) {
        this.cellCols = imageWidth / this.pixelsPerCell;
        this.cellRows = imageHeight / this.pixelsPerCell;
        if (this.cellRows * this.cellCols > this.cells.length) {
            Cell[] a = new Cell[this.cellCols * this.cellRows];
            System.arraycopy(this.cells, 0, a, 0, this.cells.length);
            for (int i = this.cells.length; i < a.length; ++i) {
                a[i] = new Cell();
                a[i].histogram = new float[this.orientationBins];
            }
            this.cells = a;
        }
    }

    public void getDescriptorsInRegion(int pixelX0, int pixelY0, int pixelX1, int pixelY1, List<TupleDesc_F64> output) {
        int gridX0 = (int)Math.ceil((double)pixelX0 / (double)this.pixelsPerCell);
        int gridY0 = (int)Math.ceil((double)pixelY0 / (double)this.pixelsPerCell);
        int gridX1 = pixelX1 / this.pixelsPerCell - this.cellsPerBlockX;
        int gridY1 = pixelY1 / this.pixelsPerCell - this.cellsPerBlockY;
        for (int y = gridY0; y <= gridY1; ++y) {
            int index = y * this.cellCols + gridX0;
            for (int x = gridX0; x <= gridX1; ++x) {
                output.add((TupleDesc_F64)this.descriptions.get(index++));
            }
        }
    }

    void computeDescriptor(int row, int col) {
        ((Point2D_I32)this.locations.grow()).set(col * this.pixelsPerCell, row * this.pixelsPerCell);
        TupleDesc_F64 d = (TupleDesc_F64)this.descriptions.grow();
        int indexDesc = 0;
        for (int i = 0; i < this.cellsPerBlockY; ++i) {
            for (int j = 0; j < this.cellsPerBlockX; ++j) {
                Cell c = this.cells[(row + i) * this.cellCols + (col + j)];
                for (int k = 0; k < c.histogram.length; ++k) {
                    d.value[indexDesc++] = c.histogram[k];
                }
            }
        }
        DescribeSiftCommon.normalizeDescriptor(d, 0.2);
    }

    void computeCellHistograms() {
        int width = this.cellCols * this.pixelsPerCell;
        int height = this.cellRows * this.pixelsPerCell;
        float angleBinSize = GrlConstants.F_PI / (float)this.orientationBins;
        int indexCell = 0;
        for (int i = 0; i < height; i += this.pixelsPerCell) {
            int j = 0;
            while (j < width) {
                Cell c = this.cells[indexCell];
                c.reset();
                for (int k = 0; k < this.pixelsPerCell; ++k) {
                    int indexPixel = (i + k) * this.derivX.width + j;
                    int l = 0;
                    while (l < this.pixelsPerCell) {
                        float pixelDX = this.derivX.data[indexPixel];
                        float pixelDY = this.derivY.data[indexPixel];
                        float angle = UtilAngle.atanSafe(pixelDY, pixelDX) + GrlConstants.F_PId2;
                        float magnitude = (float)Math.sqrt(pixelDX * pixelDX + pixelDY * pixelDY);
                        float findex0 = angle / angleBinSize;
                        int index0 = (int)findex0;
                        float weight1 = findex0 - (float)index0;
                        int index1 = ((index0 %= this.orientationBins) + 1) % this.orientationBins;
                        int n = index0;
                        c.histogram[n] = c.histogram[n] + magnitude * (1.0f - weight1);
                        int n2 = index1;
                        c.histogram[n2] = c.histogram[n2] + magnitude * weight1;
                        ++l;
                        ++indexPixel;
                    }
                }
                j += this.pixelsPerCell;
                ++indexCell;
            }
        }
    }

    public int getCellRows() {
        return this.cellRows;
    }

    public int getCellCols() {
        return this.cellCols;
    }

    public Cell getCell(int row, int col) {
        return this.cells[row * this.cellCols + col];
    }

    public static class Cell {
        public float[] histogram;

        public void reset() {
            Arrays.fill(this.histogram, 0.0f);
        }
    }
}

