/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.color;

import boofcv.alg.feature.color.Histogram_F64;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.Planar;

public class HistogramFeatureOps {
    public static void histogram(GrayU8 image, int maxPixelValue, TupleDesc_F64 histogram) {
        int numBins = histogram.size();
        int divisor = maxPixelValue + 1;
        histogram.fill(0.0);
        for (int y = 0; y < image.height; ++y) {
            int index = image.startIndex + y * image.stride;
            int x = 0;
            while (x < image.width) {
                int bin;
                int value = image.data[index] & 0xFF;
                int n = bin = numBins * value / divisor;
                histogram.value[n] = histogram.value[n] + 1.0;
                ++x;
                ++index;
            }
        }
    }

    public static void histogram(GrayU16 image, int maxPixelValue, TupleDesc_F64 histogram) {
        int numBins = histogram.size();
        int divisor = maxPixelValue + 1;
        histogram.fill(0.0);
        for (int y = 0; y < image.height; ++y) {
            int index = image.startIndex + y * image.stride;
            int x = 0;
            while (x < image.width) {
                int bin;
                int value = image.data[index] & 0xFFFF;
                int n = bin = numBins * value / divisor;
                histogram.value[n] = histogram.value[n] + 1.0;
                ++x;
                ++index;
            }
        }
    }

    public static void histogram(GrayF32 image, float minPixelValue, float maxPixelValue, TupleDesc_F64 histogram) {
        int numBins = histogram.size();
        float divisor = maxPixelValue - minPixelValue;
        histogram.fill(0.0);
        for (int y = 0; y < image.height; ++y) {
            int index = image.startIndex + y * image.stride;
            int x = 0;
            while (x < image.width) {
                int bin = (int)((float)numBins * (image.data[index] - minPixelValue) / divisor);
                if (bin == numBins) {
                    int n = bin - 1;
                    histogram.value[n] = histogram.value[n] + 1.0;
                } else {
                    int n = bin;
                    histogram.value[n] = histogram.value[n] + 1.0;
                }
                ++x;
                ++index;
            }
        }
    }

    public static void histogram_F32(Planar<GrayF32> image, Histogram_F64 histogram) {
        if (image.getNumBands() != histogram.getDimensions()) {
            throw new IllegalArgumentException("Number of bands in the image and histogram must be the same");
        }
        if (!histogram.isRangeSet()) {
            throw new IllegalArgumentException("Must specify range along each dimension in histogram");
        }
        int D2 = histogram.getDimensions();
        int[] coordinate = new int[D2];
        histogram.fill(0.0);
        for (int y = 0; y < image.getHeight(); ++y) {
            int imageIndex = image.getStartIndex() + y * image.getStride();
            int x = 0;
            while (x < image.getWidth()) {
                int index;
                for (int i = 0; i < D2; ++i) {
                    coordinate[i] = histogram.getDimensionIndex(i, image.getBand((int)i).data[imageIndex]);
                }
                int n = index = histogram.getIndex(coordinate);
                histogram.value[n] = histogram.value[n] + 1.0;
                ++x;
                ++imageIndex;
            }
        }
    }

    public static void histogram_U8(Planar<GrayU8> image, Histogram_F64 histogram) {
        if (image.getNumBands() != histogram.getDimensions()) {
            throw new IllegalArgumentException("Number of bands in the image and histogram must be the same");
        }
        if (!histogram.isRangeSet()) {
            throw new IllegalArgumentException("Must specify range along each dimension in histogram");
        }
        int D2 = histogram.getDimensions();
        int[] coordinate = new int[D2];
        histogram.fill(0.0);
        for (int y = 0; y < image.getHeight(); ++y) {
            int imageIndex = image.getStartIndex() + y * image.getStride();
            int x = 0;
            while (x < image.getWidth()) {
                int index;
                for (int i = 0; i < D2; ++i) {
                    coordinate[i] = histogram.getDimensionIndex(i, image.getBand((int)i).data[imageIndex] & 0xFF);
                }
                int n = index = histogram.getIndex(coordinate);
                histogram.value[n] = histogram.value[n] + 1.0;
                ++x;
                ++imageIndex;
            }
        }
    }
}

