/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.associate;

import boofcv.abst.feature.associate.AssociateDescription2D;
import boofcv.abst.feature.associate.ScoreAssociation;
import boofcv.alg.feature.associate.FindUnassociated;
import boofcv.alg.feature.associate.StereoConsistencyCheck;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.feature.MatchScoreType;
import boofcv.struct.feature.TupleDesc;
import georegression.struct.point.Point2D_F64;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_I32;

public class AssociateStereo2D<Desc extends TupleDesc>
extends StereoConsistencyCheck
implements AssociateDescription2D<Desc> {
    private ScoreAssociation<Desc> scorer;
    private FastQueue<AssociatedIndex> matches = new FastQueue<AssociatedIndex>(AssociatedIndex::new);
    private GrowQueue_I32 unassociatedSrc = new GrowQueue_I32();
    private FindUnassociated unassociated = new FindUnassociated();
    private double scoreThreshold = Double.MAX_VALUE;
    private FastQueue<Point2D_F64> locationLeft = new FastQueue<Point2D_F64>(Point2D_F64::new);
    private FastQueue<Point2D_F64> locationRight = new FastQueue<Point2D_F64>(Point2D_F64::new);
    private FastAccess<Desc> descriptionsLeft;
    private FastAccess<Desc> descriptionsRight;

    public AssociateStereo2D(ScoreAssociation<Desc> scorer, double locationTolerance, Class<Desc> descType) {
        super(locationTolerance, locationTolerance);
        this.scorer = scorer;
    }

    @Override
    public void setSource(FastAccess<Point2D_F64> location, FastAccess<Desc> descriptions) {
        this.locationLeft.reset();
        for (int i = 0; i < location.size; ++i) {
            Point2D_F64 orig = location.get(i);
            Point2D_F64 rectified = this.locationLeft.grow();
            this.leftImageToRect.compute(orig.x, orig.y, rectified);
        }
        this.descriptionsLeft = descriptions;
    }

    @Override
    public void setDestination(FastAccess<Point2D_F64> location, FastAccess<Desc> descriptions) {
        this.locationRight.reset();
        for (int i = 0; i < location.size; ++i) {
            Point2D_F64 orig = location.get(i);
            Point2D_F64 rectified = this.locationRight.grow();
            this.rightImageToRect.compute(orig.x, orig.y, rectified);
        }
        this.descriptionsRight = descriptions;
    }

    @Override
    public void associate() {
        this.matches.reset();
        this.unassociatedSrc.reset();
        for (int i = 0; i < this.locationLeft.size; ++i) {
            Point2D_F64 left = (Point2D_F64)this.locationLeft.get(i);
            TupleDesc descLeft = (TupleDesc)this.descriptionsLeft.get(i);
            int bestIndex = -1;
            double bestScore = this.scoreThreshold;
            for (int j = 0; j < this.locationRight.size; ++j) {
                double dist;
                Point2D_F64 right = (Point2D_F64)this.locationRight.get(j);
                if (!this.checkRectified(left, right) || !((dist = this.scorer.score(descLeft, (TupleDesc)this.descriptionsRight.get(j))) < bestScore)) continue;
                bestScore = dist;
                bestIndex = j;
            }
            if (bestIndex >= 0) {
                this.matches.grow().setAssociation(i, bestIndex, bestScore);
                continue;
            }
            this.unassociatedSrc.push(i);
        }
    }

    public FastQueue<AssociatedIndex> getMatches() {
        return this.matches;
    }

    @Override
    public GrowQueue_I32 getUnassociatedSource() {
        return this.unassociatedSrc;
    }

    @Override
    public GrowQueue_I32 getUnassociatedDestination() {
        return this.unassociated.checkDestination(this.matches, this.locationRight.size);
    }

    @Override
    public void setMaxScoreThreshold(double score) {
        this.scoreThreshold = score < 0.0 ? Double.MAX_VALUE : score;
    }

    @Override
    public MatchScoreType getScoreType() {
        return this.scorer.getScoreType();
    }

    @Override
    public boolean uniqueSource() {
        return true;
    }

    @Override
    public boolean uniqueDestination() {
        return false;
    }
}

