/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.associate;

import boofcv.abst.feature.associate.ScoreAssociation;
import boofcv.alg.feature.associate.AssociateGreedyBase;
import boofcv.concurrency.BoofConcurrency;
import org.ddogleg.struct.FastAccess;

public class AssociateGreedy_MT<D>
extends AssociateGreedyBase<D> {
    public AssociateGreedy_MT(ScoreAssociation<D> score, boolean backwardsValidation) {
        super(score, backwardsValidation);
    }

    @Override
    public void associate(FastAccess<D> src, FastAccess<D> dst) {
        this.fitQuality.reset();
        this.pairs.reset();
        this.workBuffer.reset();
        this.pairs.resize(src.size);
        this.fitQuality.resize(src.size);
        this.workBuffer.resize(src.size * dst.size);
        double ratioTest = this.ratioTest;
        BoofConcurrency.loopFor(0, src.size, i -> {
            int j;
            double bestScore;
            Object a = src.data[i];
            double secondBest = bestScore = this.maxFitError;
            int bestIndex = -1;
            int workIdx = i * dst.size;
            for (j = 0; j < dst.size; ++j) {
                Object b = dst.data[j];
                double fit = this.score.score(a, b);
                this.workBuffer.set(workIdx + j, fit);
                if (!(fit <= bestScore)) continue;
                bestIndex = j;
                secondBest = bestScore;
                bestScore = fit;
            }
            if (ratioTest < 1.0 && bestIndex != -1 && bestScore != 0.0) {
                for (j = bestIndex + 1; j < dst.size; ++j) {
                    double fit = this.workBuffer.get(workIdx + j);
                    if (!(fit < secondBest)) continue;
                    secondBest = fit;
                }
                this.pairs.set(i, secondBest * ratioTest >= bestScore ? bestIndex : -1);
            } else {
                this.pairs.set(i, bestIndex);
            }
            this.fitQuality.set(i, bestScore);
        });
        if (this.backwardsValidation) {
            BoofConcurrency.loopFor(0, src.size, i -> {
                int match = this.pairs.data[i];
                if (match == -1) {
                    return;
                }
                double scoreToBeat = this.workBuffer.data[i * dst.size + match];
                int j = 0;
                while (j < src.size) {
                    if (this.workBuffer.data[match] <= scoreToBeat && j != i) {
                        this.pairs.data[i] = -1;
                        this.fitQuality.data[i] = Double.MAX_VALUE;
                        break;
                    }
                    ++j;
                    match += dst.size;
                }
            });
        }
    }
}

