/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.spherical;

import boofcv.struct.geo.GeoLL_F64;
import georegression.geometry.ConvertCoordinates3D_F64;
import georegression.metric.UtilAngle;
import georegression.misc.GrlConstants;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;

public class EquirectangularTools_F64 {
    int width;
    int height;
    GeoLL_F64 temp = new GeoLL_F64();

    public void configure(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void equiToNorm(double x, double y, Point3D_F64 norm) {
        this.equiToLatLon(x, y, this.temp);
        ConvertCoordinates3D_F64.latlonToUnitVector(this.temp.lat, this.temp.lon, norm);
    }

    public void normToEqui(double nx, double ny, double nz, Point2D_F64 rect) {
        double r = Math.sqrt(nx * nx + ny * ny);
        double lon = Math.atan2(ny, nx);
        double lat = UtilAngle.atanSafe(-nz, r);
        this.latlonToEqui(lat, lon, rect);
    }

    public void equiToNormFV(double x, double y, Point3D_F64 norm) {
        this.equiToLatLonFV(x, y, this.temp);
        ConvertCoordinates3D_F64.latlonToUnitVector(this.temp.lat, this.temp.lon, norm);
    }

    public void normToEquiFV(double nx, double ny, double nz, Point2D_F64 rect) {
        double r = Math.sqrt(nx * nx + ny * ny);
        double lon = Math.atan2(ny, nx);
        double lat = UtilAngle.atanSafe(-nz, r);
        this.latlonToEquiFV(lat, lon, rect);
    }

    public void equiToLatLon(double x, double y, GeoLL_F64 geo) {
        geo.lon = (x / (double)this.width - 0.5) * GrlConstants.PI2;
        geo.lat = (y / (double)(this.height - 1) - 0.5) * GrlConstants.PI;
    }

    public void equiToLatLonFV(double x, double y, GeoLL_F64 geo) {
        geo.lon = (x / (double)this.width - 0.5) * GrlConstants.PI2;
        geo.lat = (((double)this.height - y - 1.0) / (double)(this.height - 1) - 0.5) * GrlConstants.PI;
    }

    public void latlonToEqui(double lat, double lon, Point2D_F64 rect) {
        rect.x = UtilAngle.wrapZeroToOne(lon / GrlConstants.PI2 + 0.5) * (double)this.width;
        rect.y = UtilAngle.reflectZeroToOne(lat / GrlConstants.PI + 0.5) * (double)(this.height - 1);
    }

    public void latlonToEquiFV(double lat, double lon, Point2D_F64 rect) {
        rect.x = UtilAngle.wrapZeroToOne(lon / GrlConstants.PI2 + 0.5) * (double)this.width;
        rect.y = UtilAngle.reflectZeroToOne(lat / GrlConstants.PI + 0.5) * (double)(this.height - 1);
        rect.y = (double)this.height - rect.y - 1.0;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

