/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.border;

import boofcv.alg.border.GrowBorder;
import boofcv.struct.border.ImageBorder;
import boofcv.struct.border.ImageBorder_F32;
import boofcv.struct.border.ImageBorder_F64;
import boofcv.struct.border.ImageBorder_S32;
import boofcv.struct.border.ImageBorder_S64;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayI;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS64;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;

public interface GrowBorderSB<T extends ImageGray<T>, PixelArray>
extends GrowBorder<T, PixelArray> {

    public static class SB_F64
    implements GrowBorderSB<GrayF64, double[]> {
        GrayF64 image;
        ImageBorder_F64 border;

        @Override
        public void setBorder(ImageBorder<GrayF64> border) {
            this.border = (ImageBorder_F64)border;
        }

        @Override
        public void setImage(GrayF64 image) {
            this.image = image;
            this.border.setImage(image);
        }

        @Override
        public ImageType<GrayF64> getImageType() {
            return ImageType.SB_F64;
        }

        @Override
        public void growRow(int y, int borderLower, int borderUpper, double[] output, int offset) {
            int idxDst = offset;
            if (y < 0 || y >= this.image.height) {
                int end = this.image.width + borderUpper;
                for (int i = -borderLower; i < end; ++i) {
                    output[idxDst++] = this.border.getOutside(i, y);
                }
            } else {
                int i;
                for (i = borderLower; i > 0; --i) {
                    output[idxDst++] = this.border.getOutside(-i, y);
                }
                System.arraycopy(this.image.data, this.image.getIndex(0, y), output, idxDst, this.image.width);
                idxDst += this.image.width;
                for (i = 0; i < borderUpper; ++i) {
                    output[idxDst++] = this.border.getOutside(this.image.width + i, y);
                }
            }
        }

        @Override
        public void growCol(int x, int borderLower, int borderUpper, double[] output, int offset) {
            int idxDst = offset;
            if (x < 0 || x >= this.image.width) {
                int end = this.image.height + borderUpper;
                for (int i = -borderLower; i < end; ++i) {
                    output[idxDst++] = this.border.getOutside(x, i);
                }
            } else {
                int i;
                int idxSrc = this.image.startIndex + x;
                for (i = borderLower; i > 0; --i) {
                    output[idxDst++] = this.border.getOutside(x, -i);
                }
                int y = 0;
                while (y < this.image.height) {
                    output[idxDst++] = this.image.data[idxSrc];
                    ++y;
                    idxSrc += this.image.stride;
                }
                for (i = 0; i < borderUpper; ++i) {
                    output[idxDst++] = this.border.getOutside(x, this.image.height + i);
                }
            }
        }
    }

    public static class SB_F32
    implements GrowBorderSB<GrayF32, float[]> {
        GrayF32 image;
        ImageBorder_F32 border;

        @Override
        public void setBorder(ImageBorder<GrayF32> border) {
            this.border = (ImageBorder_F32)border;
        }

        @Override
        public void setImage(GrayF32 image) {
            this.image = image;
            this.border.setImage(image);
        }

        @Override
        public ImageType<GrayF32> getImageType() {
            return ImageType.SB_F32;
        }

        @Override
        public void growRow(int y, int borderLower, int borderUpper, float[] output, int offset) {
            int idxDst = offset;
            if (y < 0 || y >= this.image.height) {
                int end = this.image.width + borderUpper;
                for (int i = -borderLower; i < end; ++i) {
                    output[idxDst++] = this.border.getOutside(i, y);
                }
            } else {
                int i;
                for (i = borderLower; i > 0; --i) {
                    output[idxDst++] = this.border.getOutside(-i, y);
                }
                System.arraycopy(this.image.data, this.image.getIndex(0, y), output, idxDst, this.image.width);
                idxDst += this.image.width;
                for (i = 0; i < borderUpper; ++i) {
                    output[idxDst++] = this.border.getOutside(this.image.width + i, y);
                }
            }
        }

        @Override
        public void growCol(int x, int borderLower, int borderUpper, float[] output, int offset) {
            int idxDst = offset;
            if (x < 0 || x >= this.image.width) {
                int end = this.image.height + borderUpper;
                for (int i = -borderLower; i < end; ++i) {
                    output[idxDst++] = this.border.getOutside(x, i);
                }
            } else {
                int i;
                int idxSrc = this.image.startIndex + x;
                for (i = borderLower; i > 0; --i) {
                    output[idxDst++] = this.border.getOutside(x, -i);
                }
                int y = 0;
                while (y < this.image.height) {
                    output[idxDst++] = this.image.data[idxSrc];
                    ++y;
                    idxSrc += this.image.stride;
                }
                for (i = 0; i < borderUpper; ++i) {
                    output[idxDst++] = this.border.getOutside(x, this.image.height + i);
                }
            }
        }
    }

    public static class SB_S64
    implements GrowBorderSB<GrayS64, long[]> {
        GrayS64 image;
        ImageBorder_S64 border;

        @Override
        public void setBorder(ImageBorder<GrayS64> border) {
            this.border = (ImageBorder_S64)border;
        }

        @Override
        public void setImage(GrayS64 image) {
            this.image = image;
            this.border.setImage(image);
        }

        @Override
        public ImageType<GrayS64> getImageType() {
            return ImageType.SB_S64;
        }

        @Override
        public void growRow(int y, int borderLower, int borderUpper, long[] output, int offset) {
            int idxDst = offset;
            if (y < 0 || y >= this.image.height) {
                int end = this.image.width + borderUpper;
                for (int i = -borderLower; i < end; ++i) {
                    output[idxDst++] = this.border.getOutside(i, y);
                }
            } else {
                int i;
                for (i = borderLower; i > 0; --i) {
                    output[idxDst++] = this.border.getOutside(-i, y);
                }
                System.arraycopy(this.image.data, this.image.getIndex(0, y), output, idxDst, this.image.width);
                idxDst += this.image.width;
                for (i = 0; i < borderUpper; ++i) {
                    output[idxDst++] = this.border.getOutside(this.image.width + i, y);
                }
            }
        }

        @Override
        public void growCol(int x, int borderLower, int borderUpper, long[] output, int offset) {
            int idxDst = offset;
            if (x < 0 || x >= this.image.width) {
                int end = this.image.height + borderUpper;
                for (int i = -borderLower; i < end; ++i) {
                    output[idxDst++] = this.border.getOutside(x, i);
                }
            } else {
                int i;
                int idxSrc = this.image.startIndex + x;
                for (i = borderLower; i > 0; --i) {
                    output[idxDst++] = this.border.getOutside(x, -i);
                }
                int y = 0;
                while (y < this.image.height) {
                    output[idxDst++] = this.image.data[idxSrc];
                    ++y;
                    idxSrc += this.image.stride;
                }
                for (i = 0; i < borderUpper; ++i) {
                    output[idxDst++] = this.border.getOutside(x, this.image.height + i);
                }
            }
        }
    }

    public static class SB_S32
    implements GrowBorderSB<GrayS32, int[]> {
        GrayS32 image;
        ImageBorder_S32<GrayS32> border;

        @Override
        public void setBorder(ImageBorder<GrayS32> border) {
            this.border = (ImageBorder_S32)border;
        }

        @Override
        public void setImage(GrayS32 image) {
            this.image = image;
            this.border.setImage(image);
        }

        @Override
        public ImageType<GrayS32> getImageType() {
            return ImageType.SB_S32;
        }

        @Override
        public void growRow(int y, int borderLower, int borderUpper, int[] output, int offset) {
            int idxDst = offset;
            if (y < 0 || y >= this.image.height) {
                int end = this.image.width + borderUpper;
                for (int i = -borderLower; i < end; ++i) {
                    output[idxDst++] = this.border.getOutside(i, y);
                }
            } else {
                int i;
                for (i = borderLower; i > 0; --i) {
                    output[idxDst++] = this.border.getOutside(-i, y);
                }
                System.arraycopy(this.image.data, this.image.getIndex(0, y), output, idxDst, this.image.width);
                idxDst += this.image.width;
                for (i = 0; i < borderUpper; ++i) {
                    output[idxDst++] = this.border.getOutside(this.image.width + i, y);
                }
            }
        }

        @Override
        public void growCol(int x, int borderLower, int borderUpper, int[] output, int offset) {
            int idxDst = offset;
            if (x < 0 || x >= this.image.width) {
                int end = this.image.height + borderUpper;
                for (int i = -borderLower; i < end; ++i) {
                    output[idxDst++] = this.border.getOutside(x, i);
                }
            } else {
                int i;
                int idxSrc = this.image.startIndex + x;
                for (i = borderLower; i > 0; --i) {
                    output[idxDst++] = this.border.getOutside(x, -i);
                }
                int y = 0;
                while (y < this.image.height) {
                    output[idxDst++] = this.image.data[idxSrc];
                    ++y;
                    idxSrc += this.image.stride;
                }
                for (i = 0; i < borderUpper; ++i) {
                    output[idxDst++] = this.border.getOutside(x, this.image.height + i);
                }
            }
        }
    }

    public static class SB_I16<T extends GrayI16<T>>
    extends SB_I_S32<T, short[]> {
        public SB_I16(ImageType<T> imageType) {
            super(imageType);
        }

        @Override
        public void growRow(int y, int borderLower, int borderUpper, short[] output, int offset) {
            int idxDst = offset;
            if (y < 0 || y >= ((GrayI16)this.image).height) {
                int end = ((GrayI16)this.image).width + borderUpper;
                for (int i = -borderLower; i < end; ++i) {
                    output[idxDst++] = (short)this.border.getOutside(i, y);
                }
            } else {
                int i;
                for (i = borderLower; i > 0; --i) {
                    output[idxDst++] = (short)this.border.getOutside(-i, y);
                }
                System.arraycopy(((GrayI16)this.image).data, ((GrayI16)this.image).getIndex(0, y), output, idxDst, ((GrayI16)this.image).width);
                idxDst += ((GrayI16)this.image).width;
                for (i = 0; i < borderUpper; ++i) {
                    output[idxDst++] = (short)this.border.getOutside(((GrayI16)this.image).width + i, y);
                }
            }
        }

        @Override
        public void growCol(int x, int borderLower, int borderUpper, short[] output, int offset) {
            int idxDst = offset;
            if (x < 0 || x >= ((GrayI16)this.image).width) {
                int end = ((GrayI16)this.image).height + borderUpper;
                for (int i = -borderLower; i < end; ++i) {
                    output[idxDst++] = (short)this.border.getOutside(x, i);
                }
            } else {
                int i;
                int idxSrc = ((GrayI16)this.image).startIndex + x;
                for (i = borderLower; i > 0; --i) {
                    output[idxDst++] = (short)this.border.getOutside(x, -i);
                }
                int y = 0;
                while (y < ((GrayI16)this.image).height) {
                    output[idxDst++] = ((GrayI16)this.image).data[idxSrc];
                    ++y;
                    idxSrc += ((GrayI16)this.image).stride;
                }
                for (i = 0; i < borderUpper; ++i) {
                    output[idxDst++] = (short)this.border.getOutside(x, ((GrayI16)this.image).height + i);
                }
            }
        }
    }

    public static class SB_I8<T extends GrayI8<T>>
    extends SB_I_S32<T, byte[]> {
        public SB_I8(ImageType<T> imageType) {
            super(imageType);
        }

        @Override
        public void growRow(int y, int borderLower, int borderUpper, byte[] output, int offset) {
            int idxDst = offset;
            if (y < 0 || y >= ((GrayI8)this.image).height) {
                int end = ((GrayI8)this.image).width + borderUpper;
                for (int i = -borderLower; i < end; ++i) {
                    output[idxDst++] = (byte)this.border.getOutside(i, y);
                }
            } else {
                int i;
                for (i = borderLower; i > 0; --i) {
                    output[idxDst++] = (byte)this.border.getOutside(-i, y);
                }
                System.arraycopy(((GrayI8)this.image).data, ((GrayI8)this.image).getIndex(0, y), output, idxDst, ((GrayI8)this.image).width);
                idxDst += ((GrayI8)this.image).width;
                for (i = 0; i < borderUpper; ++i) {
                    output[idxDst++] = (byte)this.border.getOutside(((GrayI8)this.image).width + i, y);
                }
            }
        }

        @Override
        public void growCol(int x, int borderLower, int borderUpper, byte[] output, int offset) {
            int idxDst = offset;
            if (x < 0 || x >= ((GrayI8)this.image).width) {
                int end = ((GrayI8)this.image).height + borderUpper;
                for (int i = -borderLower; i < end; ++i) {
                    output[idxDst++] = (byte)this.border.getOutside(x, i);
                }
            } else {
                int i;
                int idxSrc = ((GrayI8)this.image).startIndex + x;
                for (i = borderLower; i > 0; --i) {
                    output[idxDst++] = (byte)this.border.getOutside(x, -i);
                }
                int y = 0;
                while (y < ((GrayI8)this.image).height) {
                    output[idxDst++] = ((GrayI8)this.image).data[idxSrc];
                    ++y;
                    idxSrc += ((GrayI8)this.image).stride;
                }
                for (i = 0; i < borderUpper; ++i) {
                    output[idxDst++] = (byte)this.border.getOutside(x, ((GrayI8)this.image).height + i);
                }
            }
        }
    }

    public static abstract class SB_I_S32<T extends GrayI<T>, PixelArray>
    implements GrowBorderSB<T, PixelArray> {
        T image;
        ImageBorder_S32<T> border;
        ImageType<T> imageType;

        public SB_I_S32(ImageType<T> imageType) {
            this.imageType = imageType;
        }

        @Override
        public void setBorder(ImageBorder<T> _border) {
            this.border = (ImageBorder_S32)_border;
        }

        @Override
        public void setImage(T image) {
            this.image = image;
            this.border.setImage(image);
        }

        @Override
        public ImageType<T> getImageType() {
            return this.imageType;
        }
    }
}

