/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.background;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.background.BackgroundModel;
import boofcv.struct.distort.Point2Transform2Model_F32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import georegression.struct.InvertibleTransform;
import georegression.struct.point.Point2D_F32;

public abstract class BackgroundModelMoving<T extends ImageBase<T>, MotionModel extends InvertibleTransform<MotionModel>>
extends BackgroundModel<T> {
    protected Point2Transform2Model_F32<MotionModel> transform;
    protected MotionModel homeToWorld;
    protected MotionModel worldToHome;
    protected MotionModel currentToWorld;
    protected MotionModel worldToCurrent;
    protected int backgroundWidth;
    protected int backgroundHeight;
    protected Point2D_F32[] corners = new Point2D_F32[4];
    protected Point2D_F32 work = new Point2D_F32();

    public BackgroundModelMoving(Point2Transform2Model_F32<MotionModel> transform, ImageType<T> imageType) {
        super(imageType);
        this.transform = transform;
        this.homeToWorld = (InvertibleTransform)transform.newInstanceModel();
        this.worldToHome = (InvertibleTransform)transform.newInstanceModel();
        this.currentToWorld = (InvertibleTransform)transform.newInstanceModel();
        this.worldToCurrent = (InvertibleTransform)transform.newInstanceModel();
        for (int i = 0; i < this.corners.length; ++i) {
            this.corners[i] = new Point2D_F32();
        }
    }

    public abstract void initialize(int var1, int var2, MotionModel var3);

    public void updateBackground(MotionModel homeToCurrent, T frame) {
        this.worldToHome.concat(homeToCurrent, this.worldToCurrent);
        this.worldToCurrent.invert(this.currentToWorld);
        this.transform.setModel(this.currentToWorld);
        this.transform.compute(0.0f, 0.0f, this.corners[0]);
        this.transform.compute(((ImageBase)frame).width - 1, 0.0f, this.corners[1]);
        this.transform.compute(((ImageBase)frame).width - 1, ((ImageBase)frame).height - 1, this.corners[2]);
        this.transform.compute(0.0f, ((ImageBase)frame).height - 1, this.corners[3]);
        int x0 = Integer.MAX_VALUE;
        int y0 = Integer.MAX_VALUE;
        int x1 = -2147483647;
        int y1 = -2147483647;
        for (int i = 0; i < 4; ++i) {
            Point2D_F32 p = this.corners[i];
            int x = (int)p.x;
            int y = (int)p.y;
            if (x0 > x) {
                x0 = x;
            }
            if (y0 > y) {
                y0 = y;
            }
            if (x1 < x) {
                x1 = x;
            }
            if (y1 >= y) continue;
            y1 = y;
        }
        ++x1;
        ++y1;
        if (x0 < 0) {
            x0 = 0;
        }
        if (x1 > this.backgroundWidth) {
            x1 = this.backgroundWidth;
        }
        if (y0 < 0) {
            y0 = 0;
        }
        if (y1 > this.backgroundHeight) {
            y1 = this.backgroundHeight;
        }
        this.updateBackground(x0, y0, x1, y1, frame);
    }

    protected abstract void updateBackground(int var1, int var2, int var3, int var4, T var5);

    public void segment(MotionModel homeToCurrent, T frame, GrayU8 segmented) {
        InputSanityCheck.checkSameShape(frame, segmented);
        this.worldToHome.concat(homeToCurrent, this.worldToCurrent);
        this.worldToCurrent.invert(this.currentToWorld);
        this._segment(this.currentToWorld, frame, segmented);
    }

    protected abstract void _segment(MotionModel var1, T var2, GrayU8 var3);
}

