/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.transform.census;

import boofcv.abst.filter.FilterImageInterface;
import boofcv.struct.border.ImageBorder;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Point2D_I32;
import org.ddogleg.struct.FastAccess;

public abstract class FilterCensusTransform<In extends ImageGray<In>, Out extends ImageBase<Out>>
implements FilterImageInterface<In, Out> {
    ImageBorder<In> border;
    ImageType<In> inputType;
    ImageType<Out> outType;
    int ignoreRadius;
    int sampleRadius;

    public FilterCensusTransform(int radius, ImageBorder<In> border, Class<In> imageType, ImageType<Out> outType) {
        this.border = border;
        this.inputType = ImageType.single(imageType);
        this.outType = outType;
        this.sampleRadius = radius;
        this.ignoreRadius = border == null ? radius : 0;
    }

    protected static int computeRadius(FastAccess<Point2D_I32> sample) {
        int radius = 0;
        for (int i = 0; i < sample.size; ++i) {
            Point2D_I32 p = sample.get(i);
            radius = Math.max(radius, Math.abs(p.x));
            radius = Math.max(radius, Math.abs(p.y));
        }
        return radius;
    }

    public int getRadiusX() {
        return this.sampleRadius;
    }

    public int getRadiusY() {
        return this.sampleRadius;
    }

    @Override
    public int getBorderX() {
        return this.ignoreRadius;
    }

    @Override
    public int getBorderY() {
        return this.ignoreRadius;
    }

    @Override
    public ImageType<In> getInputType() {
        return this.inputType;
    }

    @Override
    public ImageType<Out> getOutputType() {
        return this.outType;
    }
}

