/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.tracker;

import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.abst.tracker.PointTrack;
import boofcv.abst.tracker.PointTrackerKltPyramid;
import boofcv.abst.tracker.PointTrackerTwoPass;
import boofcv.alg.feature.detect.interest.GeneralFeatureDetector;
import boofcv.alg.interpolate.InterpolateRectangle;
import boofcv.alg.tracker.klt.ConfigKlt;
import boofcv.alg.tracker.klt.KltTrackFault;
import boofcv.alg.tracker.klt.PyramidKltFeature;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.pyramid.PyramidDiscrete;
import java.util.ArrayList;
import java.util.List;

public class PointTrackerTwoPassKltPyramid<I extends ImageGray<I>, D extends ImageGray<D>>
extends PointTrackerKltPyramid<I, D>
implements PointTrackerTwoPass<I> {
    List<PyramidKltFeature> originalActive = new ArrayList<PyramidKltFeature>();
    List<PyramidKltFeature> candidateDrop = new ArrayList<PyramidKltFeature>();
    boolean finishedTracking;

    public PointTrackerTwoPassKltPyramid(ConfigKlt config, double toleranceRL, int templateRadius, PyramidDiscrete<I> pyramid, GeneralFeatureDetector<I, D> detector, ImageGradient<I, D> gradient, InterpolateRectangle<I> interpInput, InterpolateRectangle<D> interpDeriv) {
        super(config, toleranceRL, templateRadius, false, pyramid, detector, gradient, interpInput, interpDeriv, gradient.getDerivativeType().getImageClass());
    }

    @Override
    public void process(I image) {
        this.input = image;
        ++this.frameID;
        this.finishedTracking = false;
        this.spawned.clear();
        this.dropped.clear();
        this.currPyr.update(image);
        this.originalActive.clear();
        this.originalActive.addAll(this.active);
        this.candidateDrop.clear();
        this.active.clear();
        this.tracker.setImage(this.currPyr.basePyramid, (ImageGray[])this.currPyr.derivX, (ImageGray[])this.currPyr.derivY);
        for (int i = 0; i < this.originalActive.size(); ++i) {
            PyramidKltFeature t = this.originalActive.get(i);
            KltTrackFault ret = this.tracker.track(t);
            boolean success = false;
            if (ret == KltTrackFault.SUCCESS && BoofMiscOps.isInside((ImageBase)this.input, t.x, t.y)) {
                this.active.add(t);
                PointTrack p = (PointTrack)t.getCookie();
                p.pixel.set(t.x, t.y);
                success = true;
            }
            if (success) continue;
            this.candidateDrop.add(t);
        }
    }

    @Override
    public void performSecondPass() {
        this.candidateDrop.clear();
        this.active.clear();
        for (int i = 0; i < this.originalActive.size(); ++i) {
            PyramidKltFeature t = this.originalActive.get(i);
            KltTrackFault ret = this.tracker.track(t);
            boolean success = false;
            if (ret == KltTrackFault.SUCCESS && BoofMiscOps.isInside((ImageBase)this.input, t.x, t.y)) {
                this.active.add(t);
                PointTrack p = (PointTrack)t.getCookie();
                p.pixel.set(t.x, t.y);
                success = true;
            }
            if (success) continue;
            this.candidateDrop.add(t);
        }
    }

    @Override
    public void finishTracking() {
        PyramidKltFeature t;
        int i = 0;
        while (i < this.active.size()) {
            t = (PyramidKltFeature)this.active.get(i);
            if (this.tracker.setDescription(t)) {
                ++i;
                continue;
            }
            this.candidateDrop.add(t);
            this.active.remove(i);
        }
        for (i = 0; i < this.candidateDrop.size(); ++i) {
            t = this.candidateDrop.get(i);
            this.dropped.add(t);
            this.unused.add(t);
        }
        this.finishedTracking = true;
    }

    @Override
    public void setHint(double pixelX, double pixelY, PointTrack track) {
        PyramidKltFeature kltTrack = (PyramidKltFeature)track.getDescription();
        kltTrack.setPosition((float)pixelX, (float)pixelY);
    }

    @Override
    public List<PointTrack> getAllTracks(List<PointTrack> list) {
        if (list == null) {
            list = new ArrayList<PointTrack>();
        }
        if (this.finishedTracking) {
            this.addToList(this.active, list);
        } else {
            this.addToList(this.originalActive, list);
        }
        return list;
    }
}

