/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.tracker;

import boofcv.abst.feature.associate.AssociateDescription2D;
import boofcv.abst.tracker.ConfigTrackerDda;
import boofcv.abst.tracker.DdaFeatureManager;
import boofcv.abst.tracker.DetectDescribeAssociate;
import boofcv.abst.tracker.PointTrack;
import boofcv.abst.tracker.PointTrackerTwoPass;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_F64;
import org.ddogleg.struct.FastAccess;

public class DetectDescribeAssociateTwoPass<I extends ImageGray<I>, Desc extends TupleDesc>
extends DetectDescribeAssociate<I, Desc>
implements PointTrackerTwoPass<I> {
    AssociateDescription2D<Desc> associate2;
    boolean sourceSet2;

    public DetectDescribeAssociateTwoPass(DdaFeatureManager<I, Desc> manager, AssociateDescription2D<Desc> associate, AssociateDescription2D<Desc> associate2, ConfigTrackerDda config) {
        super(manager, associate, config);
        this.associate2 = associate2;
    }

    @Override
    public void process(I input) {
        ++this.frameID;
        this.sourceSet2 = false;
        this.tracksActive.clear();
        this.tracksInactive.clear();
        this.tracksDropped.clear();
        this.tracksNew.clear();
        this.manager.detectFeatures(input);
        for (int setIndex = 0; setIndex < this.sets.length; ++setIndex) {
            DetectDescribeAssociate.SetTrackInfo info = this.sets[setIndex];
            info.featDst.reset();
            info.locDst.reset();
            this.manager.getFeatures(setIndex, info.locDst, info.featDst);
            if (this.tracksAll.isEmpty()) continue;
            this.putIntoSrcList(info);
            this.associate.setSource(info.locSrc, info.featSrc);
            this.associate.setDestination(info.locDst, info.featDst);
            this.associate.associate();
            this.updateTrackLocation(info, this.associate.getMatches());
        }
    }

    @Override
    public void performSecondPass() {
        boolean setSource;
        if (this.tracksAll.isEmpty()) {
            return;
        }
        boolean bl = setSource = this.associate2 != this.associate && !this.sourceSet2 && this.sets.length == 1;
        if (setSource) {
            this.sourceSet2 = true;
        }
        for (int setIndex = 0; setIndex < this.sets.length; ++setIndex) {
            DetectDescribeAssociate.SetTrackInfo info = this.sets[setIndex];
            if (setSource) {
                this.associate.setSource(info.locSrc, info.featSrc);
            }
            this.associate2.setDestination(info.locDst, info.featDst);
            this.associate2.associate();
            this.updateTrackLocation(info, this.associate2.getMatches());
        }
    }

    @Override
    public void finishTracking() {
        if (this.tracksAll.isEmpty()) {
            return;
        }
        this.tracksActive.clear();
        for (int setIndex = 0; setIndex < this.sets.length; ++setIndex) {
            DetectDescribeAssociate.SetTrackInfo info = this.sets[setIndex];
            this.updateTrackState(info);
            for (int i = 0; i < info.tracks.size(); ++i) {
                if (info.isAssociated[i]) continue;
                this.tracksInactive.add(info.tracks.get(i));
            }
        }
    }

    protected void updateTrackLocation(DetectDescribeAssociate.SetTrackInfo<Desc> info, FastAccess<AssociatedIndex> matches) {
        int i;
        info.matches.resize(matches.size);
        for (i = 0; i < matches.size; ++i) {
            ((AssociatedIndex)info.matches.get(i)).set(matches.get(i));
        }
        this.tracksActive.clear();
        for (i = 0; i < info.matches.size; ++i) {
            AssociatedIndex indexes = ((AssociatedIndex[])info.matches.data)[i];
            PointTrack track = info.tracks.get(indexes.src);
            Point2D_F64 loc = ((Point2D_F64[])info.locDst.data)[indexes.dst];
            track.pixel.set(loc.x, loc.y);
            this.tracksActive.add(track);
        }
    }

    @Override
    public void setHint(double pixelX, double pixelY, PointTrack track) {
        track.pixel.set(pixelX, pixelY);
    }
}

