/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.sfm.d3;

import boofcv.abst.sfm.AccessPointTracks3D;
import boofcv.abst.sfm.d3.StereoVisualOdometry;
import boofcv.alg.feature.associate.AssociateStereo2D;
import boofcv.alg.geo.DistanceFromModelMultiView;
import boofcv.alg.geo.pose.PnPStereoDistanceReprojectionSq;
import boofcv.alg.geo.pose.RefinePnPStereo;
import boofcv.alg.sfm.d3.VisOdomStereoQuadPnP;
import boofcv.struct.calib.StereoParameters;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.geo.Point2D3D;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.ddogleg.struct.FastQueue;

public class WrapVisOdomQuadPnP<T extends ImageGray<T>, TD extends TupleDesc>
implements StereoVisualOdometry<T>,
AccessPointTracks3D {
    VisOdomStereoQuadPnP<T, TD> alg;
    RefinePnPStereo refine;
    AssociateStereo2D<TD> associateStereo;
    PnPStereoDistanceReprojectionSq distance;
    DistanceFromModelMultiView<Se3_F64, Point2D3D> distanceMono;
    Class<T> imageType;
    long totalFeatures;

    public WrapVisOdomQuadPnP(VisOdomStereoQuadPnP<T, TD> alg, RefinePnPStereo refine, AssociateStereo2D<TD> associateStereo, PnPStereoDistanceReprojectionSq distance, DistanceFromModelMultiView<Se3_F64, Point2D3D> distanceMono, Class<T> imageType) {
        this.alg = alg;
        this.refine = refine;
        this.associateStereo = associateStereo;
        this.distance = distance;
        this.distanceMono = distanceMono;
        this.imageType = imageType;
    }

    @Override
    public boolean getTrackWorld3D(int index, Point3D_F64 world) {
        Se3_F64 left_to_world = this.alg.getLeftToWorld();
        FastQueue<VisOdomStereoQuadPnP.TrackQuad> features = this.alg.getTrackQuads();
        SePointOps_F64.transform(left_to_world, ((VisOdomStereoQuadPnP.TrackQuad)features.get((int)index)).X, world);
        return true;
    }

    @Override
    public int getTotalTracks() {
        return this.alg.getTrackQuads().size;
    }

    @Override
    public long getTrackId(int index) {
        return ((VisOdomStereoQuadPnP.TrackQuad)this.alg.getTrackQuads().get((int)index)).id;
    }

    @Override
    public void getTrackPixel(int index, Point2D_F64 pixel) {
        pixel.set(((VisOdomStereoQuadPnP.TrackQuad)this.alg.getTrackQuads().get((int)index)).v2);
    }

    @Override
    public List<Point2D_F64> getAllTracks(@Nullable List<Point2D_F64> storage) {
        if (storage == null) {
            storage = new ArrayList<Point2D_F64>();
        } else {
            storage.clear();
        }
        FastQueue<VisOdomStereoQuadPnP.TrackQuad> features = this.alg.getTrackQuads();
        for (VisOdomStereoQuadPnP.TrackQuad v : features.toList()) {
            storage.add(v.v2);
        }
        return storage;
    }

    @Override
    public boolean isTrackInlier(int index) {
        return ((VisOdomStereoQuadPnP.TrackQuad)this.alg.getTrackQuads().get((int)index)).inlier;
    }

    @Override
    public boolean isTrackNew(int index) {
        long frameId = this.alg.getFrameID();
        return ((VisOdomStereoQuadPnP.TrackQuad)this.alg.getTrackQuads().get((int)index)).firstSceneFrameID == frameId;
    }

    @Override
    public void setCalibration(StereoParameters parameters) {
        Se3_F64 leftToRight = parameters.getRightToLeft().invert((Se3_F64)null);
        this.alg.setCalibration(parameters);
        this.associateStereo.setCalibration(parameters);
        this.distance.setLeftToRight(leftToRight);
        this.distance.setIntrinsic(0, parameters.left);
        this.distance.setIntrinsic(1, parameters.right);
        this.distanceMono.setIntrinsic(0, parameters.left);
        if (this.refine != null) {
            this.refine.setLeftToRight(leftToRight);
        }
    }

    @Override
    public void reset() {
        this.alg.reset();
    }

    @Override
    public Se3_F64 getCameraToWorld() {
        return this.alg.getLeftToWorld();
    }

    @Override
    public long getFrameID() {
        return this.alg.getFrameID();
    }

    @Override
    public boolean process(T leftImage, T rightImage) {
        this.totalFeatures += (long)this.alg.getTrackQuads().size;
        return this.alg.process(leftImage, rightImage);
    }

    @Override
    public boolean isFault() {
        return false;
    }

    @Override
    public ImageType<T> getImageType() {
        return ImageType.single(this.imageType);
    }

    @Override
    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.alg.setVerbose(out, configuration);
    }
}

