/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.pose;

import boofcv.abst.geo.EstimateNofPnP;
import boofcv.alg.geo.pose.P3PLineDistance;
import boofcv.alg.geo.pose.PointDistance3;
import boofcv.struct.geo.Point2D3D;
import georegression.fitting.MotionTransformPoint;
import georegression.struct.GeoTuple_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.FastQueue;

public class WrapP3PLineDistance
implements EstimateNofPnP {
    private P3PLineDistance alg;
    private MotionTransformPoint<Se3_F64, Point3D_F64> motionFit;
    private Point3D_F64 X1 = new Point3D_F64();
    private Point3D_F64 X2 = new Point3D_F64();
    private Point3D_F64 X3 = new Point3D_F64();
    private Vector3D_F64 u1 = new Vector3D_F64();
    private Vector3D_F64 u2 = new Vector3D_F64();
    private Vector3D_F64 u3 = new Vector3D_F64();
    private List<Point3D_F64> cloudWorld = new ArrayList<Point3D_F64>();
    private List<Point3D_F64> cloudCamera = new ArrayList<Point3D_F64>();

    public WrapP3PLineDistance(P3PLineDistance alg, MotionTransformPoint<Se3_F64, Point3D_F64> motionFit) {
        this.alg = alg;
        this.motionFit = motionFit;
        this.cloudCamera.add(this.X1);
        this.cloudCamera.add(this.X2);
        this.cloudCamera.add(this.X3);
    }

    @Override
    public boolean process(List<Point2D3D> inputs, FastQueue<Se3_F64> solutions) {
        if (inputs.size() != 3) {
            throw new IllegalArgumentException("Three and only three inputs are required.  Not " + inputs.size());
        }
        solutions.reset();
        Point2D3D P1 = inputs.get(0);
        Point2D3D P2 = inputs.get(1);
        Point2D3D P3 = inputs.get(2);
        double length12 = P1.location.distance((GeoTuple_F64)P2.getLocation());
        double length13 = P1.location.distance((GeoTuple_F64)P3.getLocation());
        double length23 = P2.location.distance((GeoTuple_F64)P3.getLocation());
        if (!this.alg.process(P1.observation, P2.observation, P3.observation, length23, length13, length12)) {
            return false;
        }
        FastQueue<PointDistance3> distances = this.alg.getSolutions();
        if (distances.size == 0) {
            return false;
        }
        this.u1.set(P1.observation.x, P1.observation.y, 1.0);
        this.u2.set(P2.observation.x, P2.observation.y, 1.0);
        this.u3.set(P3.observation.x, P3.observation.y, 1.0);
        this.u1.normalize();
        this.u2.normalize();
        this.u3.normalize();
        this.cloudWorld.clear();
        this.cloudWorld.add(P1.location);
        this.cloudWorld.add(P2.location);
        this.cloudWorld.add(P3.location);
        for (int i = 0; i < distances.size; ++i) {
            PointDistance3 pd = (PointDistance3)distances.get(i);
            this.X1.set(this.u1.x * pd.dist1, this.u1.y * pd.dist1, this.u1.z * pd.dist1);
            this.X2.set(this.u2.x * pd.dist2, this.u2.y * pd.dist2, this.u2.z * pd.dist2);
            this.X3.set(this.u3.x * pd.dist3, this.u3.y * pd.dist3, this.u3.z * pd.dist3);
            if (!this.motionFit.process(this.cloudWorld, this.cloudCamera)) continue;
            Se3_F64 found = solutions.grow();
            found.set(this.motionFit.getTransformSrcToDst());
        }
        return solutions.size() != 0;
    }

    @Override
    public int getMinimumPoints() {
        return 3;
    }
}

