/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.optimization;

import boofcv.abst.geo.optimization.ModelCodecSwapData;
import boofcv.alg.geo.ModelObservationResidual;
import boofcv.struct.geo.AssociatedPair;
import java.util.List;
import org.ddogleg.fitting.modelset.ModelCodec;
import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ejml.data.DMatrixRMaj;

public class ResidualsEpipolarMatrix
implements FunctionNtoM {
    protected ModelCodec<DMatrixRMaj> param;
    protected List<AssociatedPair> obs;
    protected ModelObservationResidual<DMatrixRMaj, AssociatedPair> residual;
    protected DMatrixRMaj F = new DMatrixRMaj(3, 3);

    public ResidualsEpipolarMatrix(ModelCodec<DMatrixRMaj> param, ModelObservationResidual<DMatrixRMaj, AssociatedPair> residual) {
        this.param = param == null ? new ModelCodecSwapData(9) : param;
        this.residual = residual;
    }

    public void setObservations(List<AssociatedPair> obs) {
        this.obs = obs;
    }

    @Override
    public int getNumOfInputsN() {
        return this.param.getParamLength();
    }

    @Override
    public int getNumOfOutputsM() {
        return this.obs.size();
    }

    @Override
    public void process(double[] input, double[] output) {
        this.param.decode(input, this.F);
        this.residual.setModel(this.F);
        for (int i = 0; i < this.obs.size(); ++i) {
            AssociatedPair p = this.obs.get(i);
            output[i] = this.residual.computeResidual(p);
        }
    }
}

