/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo;

import boofcv.struct.geo.GeoModelEstimator1;
import boofcv.struct.geo.GeoModelEstimatorN;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.fitting.modelset.DistanceFromModel;
import org.ddogleg.struct.FastQueue;

public abstract class GeoModelEstimatorNto1<Model, Point>
implements GeoModelEstimator1<Model, Point> {
    private GeoModelEstimatorN<Model, Point> alg;
    private DistanceFromModel<Model, Point> distance;
    private int numTest;
    private List<Point> list = new ArrayList<Point>();
    private FastQueue<Model> solutions;

    public GeoModelEstimatorNto1(GeoModelEstimatorN<Model, Point> alg, DistanceFromModel<Model, Point> distance, FastQueue<Model> solutions, int numTest) {
        this.alg = alg;
        this.numTest = numTest;
        this.distance = distance;
        this.solutions = solutions;
    }

    @Override
    public boolean process(List<Point> points, Model estimatedModel) {
        this.list.clear();
        for (int i = 0; i < points.size() - this.numTest; ++i) {
            this.list.add(points.get(i));
        }
        if (!this.alg.process(this.list, this.solutions)) {
            return false;
        }
        Model best = null;
        int N = this.solutions.size();
        if (N == 1) {
            best = (Model)this.solutions.get(0);
        } else if (N > 1) {
            double bestScore = Double.MAX_VALUE;
            for (int i = 0; i < N; ++i) {
                Object m = this.solutions.get(i);
                this.distance.setModel(m);
                double score = 0.0;
                for (int j = this.list.size(); j < points.size(); ++j) {
                    score += this.distance.computeDistance(points.get(j));
                }
                if (!(score < bestScore)) continue;
                bestScore = score;
                best = (Model)m;
            }
        }
        if (best != null) {
            this.copy(best, estimatedModel);
            return true;
        }
        return false;
    }

    protected abstract void copy(Model var1, Model var2);

    @Override
    public int getMinimumPoints() {
        return this.alg.getMinimumPoints() + this.numTest;
    }
}

