/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.filter.convolve;

import boofcv.abst.filter.convolve.ConvolveDown;
import boofcv.struct.border.BorderType;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;

public class PlanarConvolveDown<In extends ImageGray<In>, Out extends ImageGray<Out>>
implements ConvolveDown<Planar<In>, Planar<Out>> {
    private ConvolveDown<In, Out> down;
    private ImageType<Planar<In>> inputType;
    private ImageType<Planar<Out>> outputType;

    public PlanarConvolveDown(ConvolveDown<In, Out> down, int numBands) {
        this.down = down;
        this.inputType = ImageType.pl(numBands, down.getInputType().getDataType());
        this.outputType = ImageType.pl(numBands, down.getOutputType().getDataType());
    }

    @Override
    public void process(Planar<In> in, Planar<Out> out) {
        for (int i = 0; i < in.getNumBands(); ++i) {
            this.down.process(in.getBand(i), out.getBand(i));
        }
    }

    @Override
    public int getBorderX() {
        return this.down.getBorderX();
    }

    @Override
    public int getBorderY() {
        return this.down.getBorderY();
    }

    @Override
    public ImageType<Planar<In>> getInputType() {
        return this.inputType;
    }

    @Override
    public ImageType<Planar<Out>> getOutputType() {
        return this.outputType;
    }

    @Override
    public BorderType getBorderType() {
        return this.down.getBorderType();
    }

    @Override
    public int getSkip() {
        return this.down.getSkip();
    }

    @Override
    public void setSkip(int skip) {
        this.down.setSkip(skip);
    }
}

