/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.filter.binary;

import boofcv.abst.filter.binary.InputToBinary;
import boofcv.alg.filter.binary.GThresholdImageOps;
import boofcv.concurrency.WorkArrays;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.ConfigLength;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;

public class LocalMeanBinaryFilter<T extends ImageGray<T>>
implements InputToBinary<T> {
    ImageType<T> inputType;
    T work1;
    ImageGray work2;
    WorkArrays work3;
    ConfigLength regionWidth;
    double scale;
    boolean down;

    public LocalMeanBinaryFilter(ConfigLength width, double scale, boolean down, ImageType<T> inputType) {
        this.regionWidth = width;
        this.scale = scale;
        this.down = down;
        this.inputType = inputType;
        this.work1 = (ImageGray)inputType.createImage(1, 1);
        this.work2 = (ImageGray)inputType.createImage(1, 1);
        this.work3 = GeneralizedImageOps.createWorkArray(inputType);
    }

    @Override
    public void process(T input, GrayU8 output) {
        ((ImageGray)this.work1).reshape(((ImageGray)input).width, ((ImageGray)input).height);
        this.work2.reshape(((ImageGray)input).width, ((ImageGray)input).height);
        GThresholdImageOps.localMean(input, output, this.regionWidth, this.scale, this.down, this.work1, this.work2, this.work3);
    }

    @Override
    public ImageType<T> getInputType() {
        return this.inputType;
    }
}

