/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.filter.binary;

import boofcv.abst.filter.binary.InputToBinary;
import boofcv.alg.filter.binary.GThresholdImageOps;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;

public abstract class GlobalBinaryFilter<T extends ImageGray<T>>
implements InputToBinary<T> {
    ImageType<T> inputType;
    double scale;
    boolean down;
    double minValue;
    double maxValue;

    public GlobalBinaryFilter(double minValue, double maxValue, double scale, boolean down, ImageType<T> inputType) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.down = down;
        this.scale = scale;
        this.inputType = inputType;
    }

    @Override
    public void process(T input, GrayU8 output) {
        double scale = this.down ? this.scale : (this.scale <= 0.0 ? 0.0 : 1.0 / this.scale);
        double threshold = this.computeThreshold(input) * scale;
        GThresholdImageOps.threshold(input, output, threshold, this.down);
    }

    @Override
    public ImageType<T> getInputType() {
        return this.inputType;
    }

    abstract double computeThreshold(T var1);

    public static class Entropy<T extends ImageGray<T>>
    extends GlobalBinaryFilter<T> {
        public Entropy(double minValue, double maxValue, double scale, boolean down, ImageType<T> inputType) {
            super(minValue, maxValue, scale, down, inputType);
        }

        @Override
        double computeThreshold(T input) {
            return GThresholdImageOps.computeEntropy(input, this.minValue, this.maxValue);
        }
    }

    public static class Huang<T extends ImageGray<T>>
    extends GlobalBinaryFilter<T> {
        public Huang(double minValue, double maxValue, double scale, boolean down, ImageType<T> inputType) {
            super(minValue, maxValue, scale, down, inputType);
        }

        @Override
        double computeThreshold(T input) {
            return GThresholdImageOps.computeHuang(input, this.minValue, this.maxValue);
        }
    }

    public static class Li<T extends ImageGray<T>>
    extends GlobalBinaryFilter<T> {
        public Li(double minValue, double maxValue, double scale, boolean down, ImageType<T> inputType) {
            super(minValue, maxValue, scale, down, inputType);
        }

        @Override
        double computeThreshold(T input) {
            return GThresholdImageOps.computeLi(input, this.minValue, this.maxValue);
        }
    }

    public static class Otsu<T extends ImageGray<T>>
    extends GlobalBinaryFilter<T> {
        public Otsu(double minValue, double maxValue, double scale, boolean down, ImageType<T> inputType) {
            super(minValue, maxValue, scale, down, inputType);
        }

        @Override
        double computeThreshold(T input) {
            return GThresholdImageOps.computeOtsu(input, this.minValue, this.maxValue);
        }
    }
}

