/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.filter;

import boofcv.abst.filter.FilterImageInterface;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.testing.BoofTesting;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class FilterImageReflection<Input extends ImageGray<Input>, Output extends ImageGray<Output>>
implements FilterImageInterface<Input, Output> {
    Method m;
    Class<Input> inputType;
    Class<Output> outputType;
    int borderX;
    int borderY;
    boolean outsideZero;

    public FilterImageReflection(Class owner, String methodName, int borderX, int borderY, Class<Input> inputType, Class<Output> outputType) {
        try {
            this.m = BoofTesting.findMethod(owner, methodName, inputType, outputType);
        }
        catch (RuntimeException e) {
            this.m = BoofTesting.findMethod(owner, methodName, inputType, Integer.TYPE, outputType);
        }
        this.inputType = inputType;
        this.outputType = outputType;
        this.borderX = borderX;
        this.borderY = borderY;
        Class<?>[] param = this.m.getParameterTypes();
        if (param.length != 2 && param.length != 3) {
            throw new IllegalArgumentException("Input method must have two or three inputs");
        }
        if (!ImageGray.class.isAssignableFrom(param[0]) || !ImageGray.class.isAssignableFrom(param[0])) {
            throw new IllegalArgumentException("TWo input parameters must be of type ImageGray");
        }
    }

    public FilterImageReflection(Method m, int borderX, int borderY, Class<Input> inputType, Class<Output> outputType) {
        this.m = m;
        this.inputType = inputType;
        this.outputType = outputType;
        this.borderX = borderX;
        this.borderY = borderY;
        Class<?>[] param = m.getParameterTypes();
        if (param.length != 2 && param.length != 3) {
            throw new IllegalArgumentException("Input method must have two or three inputs");
        }
        if (!ImageGray.class.isAssignableFrom(param[0]) || !ImageGray.class.isAssignableFrom(param[0])) {
            throw new IllegalArgumentException("TWo input parameters must be of type ImageGray");
        }
    }

    @Override
    public void process(Input input, Output output) {
        if (input == null) {
            throw new IllegalArgumentException("Input parameter is null");
        }
        if (output == null) {
            throw new IllegalArgumentException("Output parameter is null");
        }
        try {
            if (this.m.getParameterTypes().length == 3) {
                this.m.invoke(null, input, 1, output);
            } else {
                this.m.invoke(null, input, output);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getBorderX() {
        return this.borderX;
    }

    @Override
    public int getBorderY() {
        return this.borderY;
    }

    @Override
    public ImageType<Input> getInputType() {
        return ImageType.single(this.inputType);
    }

    @Override
    public ImageType<Output> getOutputType() {
        return ImageType.single(this.outputType);
    }
}

