/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.fiducial.calib;

import boofcv.abst.shapes.polyline.ConfigPolylineSplitMerge;
import boofcv.factory.filter.binary.ConfigThreshold;
import boofcv.factory.filter.binary.ConfigThresholdLocalOtsu;
import boofcv.factory.shape.ConfigPolygonDetector;
import boofcv.struct.ConfigLength;
import boofcv.struct.Configuration;

public class ConfigChessboardBinary
implements Configuration {
    public ConfigLength maximumCornerDistance = ConfigLength.relative(0.01, 8);
    public ConfigThreshold thresholding = new ConfigThresholdLocalOtsu(ConfigLength.relative(0.05, 10), 10.0);
    public ConfigPolygonDetector square = new ConfigPolygonDetector();

    public ConfigChessboardBinary() {
        this.thresholding.scale = 0.85;
        ((ConfigPolylineSplitMerge)this.square.detector.contourToPoly).cornerScorePenalty = 0.2;
        ((ConfigPolylineSplitMerge)this.square.detector.contourToPoly).minimumSideLength = 2;
        ((ConfigPolylineSplitMerge)this.square.detector.contourToPoly).thresholdSideSplitScore = 0.0;
        ((ConfigPolylineSplitMerge)this.square.detector.contourToPoly).maxSideError = ConfigLength.relative(0.5, 4);
        this.square.detector.tangentEdgeIntensity = 2.5;
        this.square.detector.minimumContour = ConfigLength.fixed(10.0);
        this.square.detector.canTouchBorder = true;
        this.square.refineGray.cornerOffset = 1.0;
        this.square.refineGray.sampleRadius = 3;
        this.square.refineGray.lineSamples = 15;
        this.square.refineGray.convergeTolPixels = 0.2;
        this.square.refineGray.maxIterations = 5;
    }

    public void setTo(ConfigChessboardBinary src) {
        this.maximumCornerDistance.setTo(src.maximumCornerDistance);
        this.thresholding.setTo(src.thresholding);
        this.square.setTo(src.square);
    }

    @Override
    public void checkValidity() {
    }

    public ConfigLength getMaximumCornerDistance() {
        return this.maximumCornerDistance;
    }

    public ConfigThreshold getThresholding() {
        return this.thresholding;
    }

    public ConfigPolygonDetector getSquare() {
        return this.square;
    }

    public void setMaximumCornerDistance(ConfigLength maximumCornerDistance) {
        this.maximumCornerDistance = maximumCornerDistance;
    }

    public void setThresholding(ConfigThreshold thresholding) {
        this.thresholding = thresholding;
    }

    public void setSquare(ConfigPolygonDetector square) {
        this.square = square;
    }
}

