/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.fiducial;

import boofcv.abst.fiducial.FiducialDetectorPnP;
import boofcv.abst.fiducial.FiducialTracker;
import boofcv.alg.feature.describe.llah.LlahDocument;
import boofcv.alg.feature.describe.llah.LlahOperations;
import boofcv.alg.fiducial.dots.UchiyaMarkerImageTracker;
import boofcv.alg.fiducial.dots.UchiyaMarkerTracker;
import boofcv.struct.geo.Point2D3D;
import boofcv.struct.geo.PointIndex2D_F64;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.Polygon2D_F64;
import georegression.transform.homography.HomographyPointOps_F64;
import java.io.PrintStream;
import java.util.List;
import javax.annotation.Nullable;
import org.ddogleg.struct.FastQueue;

public class Uchiya_to_FiducialDetector<T extends ImageGray<T>>
extends FiducialDetectorPnP<T>
implements FiducialTracker<T> {
    ImageType<T> imageType;
    UchiyaMarkerImageTracker<T> tracker;
    PrintStream printTiming;
    final double markerLength;
    final FastQueue<Point2D3D> control3D = new FastQueue<Point2D3D>(Point2D3D::new);
    final Point2D_F64 norm = new Point2D_F64();

    public Uchiya_to_FiducialDetector(UchiyaMarkerImageTracker<T> tracker, double markerLength, ImageType<T> imageType) {
        this.tracker = tracker;
        this.markerLength = markerLength;
        this.imageType = imageType;
    }

    @Override
    public void detect(T input) {
        this.tracker.detect(input);
        PrintStream out = this.printTiming;
        if (out != null) {
            double timeTrack = this.tracker.getTracker().getTimeTrack();
            double timeDetect = this.tracker.getTracker().getTimeDetect();
            double timeUpdate = this.tracker.getTracker().getTimeUpdate();
            out.printf(" Uchiya: BI %5.1f EL %5.1f ER %5.1f TR %5.1f DET %5.1f UP %5.1f\n", this.tracker.getTimeBinary(), this.tracker.getTimeEllipse(), this.tracker.getTimeReject(), timeTrack, timeDetect, timeUpdate);
        }
    }

    @Override
    public void reset() {
        this.tracker.getTracker().resetTracking();
    }

    @Override
    public int totalFound() {
        return this.tracker.getTracks().size;
    }

    @Override
    public void getCenter(int which, Point2D_F64 location) {
        UchiyaMarkerTracker.Track track = (UchiyaMarkerTracker.Track)this.tracker.getTracks().get(which);
        HomographyPointOps_F64.transform(track.doc_to_imagePixel, 0.0, 0.0, location);
    }

    @Override
    public Polygon2D_F64 getBounds(int which, @Nullable Polygon2D_F64 storage) {
        if (storage == null) {
            storage = new Polygon2D_F64(4);
        } else {
            storage.vertexes.resize(4);
        }
        UchiyaMarkerTracker.Track track = (UchiyaMarkerTracker.Track)this.tracker.getTracks().get(which);
        double r = this.markerLength / 2.0;
        HomographyPointOps_F64.transform(track.doc_to_imagePixel, -r, -r, storage.get(0));
        HomographyPointOps_F64.transform(track.doc_to_imagePixel, r, -r, storage.get(1));
        HomographyPointOps_F64.transform(track.doc_to_imagePixel, r, r, storage.get(2));
        HomographyPointOps_F64.transform(track.doc_to_imagePixel, -r, r, storage.get(3));
        return storage;
    }

    @Override
    public long getId(int which) {
        UchiyaMarkerTracker.Track track = (UchiyaMarkerTracker.Track)this.tracker.getTracks().get(which);
        return track.globalDoc.documentID;
    }

    @Override
    public String getMessage(int which) {
        return "UCHIYA";
    }

    @Override
    public double getWidth(int which) {
        return this.markerLength;
    }

    @Override
    public double getSideWidth(int which) {
        return this.markerLength;
    }

    @Override
    public double getSideHeight(int which) {
        return this.markerLength;
    }

    @Override
    public List<PointIndex2D_F64> getDetectedControl(int which) {
        UchiyaMarkerTracker.Track track = (UchiyaMarkerTracker.Track)this.tracker.getTracks().get(which);
        return track.observed.toList();
    }

    @Override
    protected List<Point2D3D> getControl3D(int which) {
        UchiyaMarkerTracker.Track track = (UchiyaMarkerTracker.Track)this.tracker.getTracks().get(which);
        this.control3D.reset();
        for (int dotIdx = 0; dotIdx < track.observed.size; ++dotIdx) {
            PointIndex2D_F64 dot = (PointIndex2D_F64)track.observed.get(dotIdx);
            Point2D_F64 landmark = (Point2D_F64)track.globalDoc.landmarks.get(dot.index);
            this.pixelToNorm.compute(dot.x, dot.y, this.norm);
            this.control3D.grow().set(this.norm.x, this.norm.y, landmark.x, -landmark.y, 0.0);
        }
        return this.control3D.toList();
    }

    @Override
    public boolean hasID() {
        return true;
    }

    @Override
    public boolean hasMessage() {
        return false;
    }

    @Override
    public ImageType<T> getInputType() {
        return this.imageType;
    }

    public LlahDocument addMarker(List<Point2D_F64> locations2D) {
        double radius = this.markerLength / 2.0;
        for (int i = 0; i < locations2D.size(); ++i) {
            Point2D_F64 p = locations2D.get(i);
            if (!(p.x < -radius || p.x > radius || p.y < -radius) && !(p.y > radius)) continue;
            throw new IllegalArgumentException("Marker length is " + this.markerLength + " and " + p + " is out of bounds");
        }
        return this.getLlahOperations().createDocument(locations2D);
    }

    public LlahOperations getLlahOperations() {
        return this.tracker.getTracker().getLlahOps();
    }

    public FastQueue<UchiyaMarkerTracker.Track> getTracks() {
        return this.tracker.getTracks();
    }

    public UchiyaMarkerImageTracker<T> getTracker() {
        return this.tracker;
    }

    public void setPrintTiming(PrintStream printTiming) {
        this.printTiming = printTiming;
    }
}

