/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.detect.interest;

import boofcv.abst.feature.detect.interest.InterestPointDetector;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.abst.filter.derivative.ImageHessian;
import boofcv.alg.feature.detect.interest.EasyGeneralFeatureDetector;
import boofcv.alg.feature.detect.interest.GeneralFeatureDetector;
import boofcv.struct.QueueCorner;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I16;
import org.ddogleg.struct.FastQueue;

public class GeneralToInterestPoint<T extends ImageGray<T>, D extends ImageGray<D>>
extends EasyGeneralFeatureDetector<T, D>
implements InterestPointDetector<T> {
    double radius;
    protected FastQueue<Point2D_F64> foundPoints = new FastQueue<Point2D_F64>(10, Point2D_F64::new);

    public GeneralToInterestPoint(GeneralFeatureDetector<T, D> detector, double radius, Class<T> imageType, Class<D> derivType) {
        super(detector, imageType, derivType);
        this.radius = radius;
    }

    public GeneralToInterestPoint(GeneralFeatureDetector<T, D> detector, ImageGradient<T, D> gradient, ImageHessian<D> hessian, double radius, Class<D> derivType) {
        super(detector, gradient, hessian, derivType);
        this.radius = radius;
    }

    @Override
    public void detect(T input) {
        Point2D_I16 p;
        int i;
        QueueCorner corners;
        super.detect(input, null);
        this.foundPoints.reset();
        if (this.getDetector().isDetectMaximums()) {
            corners = this.detector.getMaximums();
            for (i = 0; i < corners.size; ++i) {
                p = (Point2D_I16)corners.get(i);
                this.foundPoints.grow().set(p.x, p.y);
            }
        }
        if (this.getDetector().isDetectMinimums()) {
            corners = this.detector.getMinimums();
            for (i = 0; i < corners.size; ++i) {
                p = (Point2D_I16)corners.get(i);
                this.foundPoints.grow().set(p.x, p.y);
            }
        }
    }

    @Override
    public int getNumberOfFeatures() {
        return this.foundPoints.size();
    }

    @Override
    public Point2D_F64 getLocation(int featureIndex) {
        return (Point2D_F64)this.foundPoints.get(featureIndex);
    }

    @Override
    public double getRadius(int featureIndex) {
        return this.radius;
    }

    @Override
    public double getOrientation(int featureIndex) {
        return 0.0;
    }

    @Override
    public boolean hasScale() {
        return false;
    }

    @Override
    public boolean hasOrientation() {
        return false;
    }

    @Override
    public ImageType<T> getInputType() {
        return ImageType.single(this.detector.getImageType());
    }
}

