/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.detdesc;

import boofcv.abst.feature.describe.DescribeRegionPoint;
import boofcv.abst.feature.detdesc.DetectDescribePoint;
import boofcv.abst.feature.detect.interest.InterestPointDetector;
import boofcv.abst.feature.orientation.OrientationImage;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Point2D_F64;
import org.ddogleg.struct.FastArray;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_F64;

public class DetectDescribeFusion<T extends ImageGray<T>, TD extends TupleDesc>
implements DetectDescribePoint<T, TD> {
    private InterestPointDetector<T> detector;
    private OrientationImage<T> orientation;
    private DescribeRegionPoint<T, TD> describe;
    private FastQueue<TD> descs;
    private GrowQueue_F64 featureRadiuses = new GrowQueue_F64(10);
    private GrowQueue_F64 featureAngles = new GrowQueue_F64(10);
    private FastArray<Point2D_F64> location = new FastArray<Point2D_F64>(Point2D_F64.class);

    public DetectDescribeFusion(InterestPointDetector<T> detector, OrientationImage<T> orientation, DescribeRegionPoint<T, TD> describe) {
        this.describe = describe;
        this.orientation = orientation;
        this.detector = detector;
        this.descs = new FastQueue<TupleDesc>(100, describe::createDescription);
    }

    @Override
    public TD createDescription() {
        return (TD)this.describe.createDescription();
    }

    @Override
    public TD getDescription(int index) {
        return (TD)((TupleDesc)this.descs.get(index));
    }

    @Override
    public ImageType<T> getInputType() {
        return this.detector.getInputType();
    }

    @Override
    public Class<TD> getDescriptionType() {
        return this.describe.getDescriptionType();
    }

    @Override
    public void detect(T input) {
        this.descs.reset();
        this.featureRadiuses.reset();
        this.featureAngles.reset();
        this.location.reset();
        if (this.orientation != null) {
            this.orientation.setImage(input);
        }
        this.describe.setImage(input);
        this.detector.detect(input);
        int N = this.detector.getNumberOfFeatures();
        for (int i = 0; i < N; ++i) {
            Point2D_F64 p = this.detector.getLocation(i);
            double radius = this.detector.getRadius(i);
            double yaw = this.detector.getOrientation(i);
            if (this.orientation != null) {
                this.orientation.setObjectRadius(radius);
                yaw = this.orientation.compute(p.x, p.y);
            }
            if (this.describe.process(p.x, p.y, yaw, radius, (TupleDesc)this.descs.grow())) {
                this.featureRadiuses.push(radius);
                this.featureAngles.push(yaw);
                this.location.add(p);
                continue;
            }
            this.descs.removeTail();
        }
    }

    @Override
    public int getNumberOfFeatures() {
        return this.location.size();
    }

    @Override
    public Point2D_F64 getLocation(int featureIndex) {
        return (Point2D_F64)this.location.get(featureIndex);
    }

    @Override
    public double getRadius(int featureIndex) {
        return this.featureRadiuses.get(featureIndex);
    }

    @Override
    public double getOrientation(int featureIndex) {
        return this.featureAngles.get(featureIndex);
    }

    @Override
    public boolean hasScale() {
        return this.detector.hasScale();
    }

    @Override
    public boolean hasOrientation() {
        if (this.orientation == null) {
            return this.detector.hasOrientation();
        }
        return true;
    }
}

