/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.describe;

import boofcv.abst.feature.describe.DescribeRegionPoint;
import boofcv.alg.feature.describe.DescribePointSurf;
import boofcv.alg.transform.ii.GIntegralImageOps;
import boofcv.struct.feature.BrightFeature;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;

public class WrapDescribeSurf<T extends ImageGray<T>, II extends ImageGray<II>>
implements DescribeRegionPoint<T, BrightFeature> {
    DescribePointSurf<II> surf;
    II ii;
    ImageType<T> imageType;
    final double canonicalRadius;

    public WrapDescribeSurf(DescribePointSurf<II> surf, Class<T> imageType) {
        this.surf = surf;
        this.imageType = ImageType.single(imageType);
        this.canonicalRadius = (double)surf.getCanonicalWidth() / 2.0;
    }

    @Override
    public BrightFeature createDescription() {
        return new BrightFeature(this.surf.getDescriptionLength());
    }

    @Override
    public void setImage(T image) {
        if (this.ii != null) {
            ((ImageGray)this.ii).reshape(((ImageGray)image).width, ((ImageGray)image).height);
        }
        this.ii = GIntegralImageOps.transform(image, this.ii);
        this.surf.setImage(this.ii);
    }

    @Override
    public boolean process(double x, double y, double orientation, double radius, BrightFeature storage) {
        double scale = radius / this.canonicalRadius;
        this.surf.describe(x, y, orientation, scale, storage);
        return true;
    }

    @Override
    public boolean isScalable() {
        return true;
    }

    @Override
    public boolean isOriented() {
        return true;
    }

    @Override
    public ImageType<T> getImageType() {
        return this.imageType;
    }

    @Override
    public double getCanonicalWidth() {
        return this.surf.getCanonicalWidth();
    }

    @Override
    public Class<BrightFeature> getDescriptionType() {
        return BrightFeature.class;
    }
}

